#ifndef XDDocument_hxx
#define XDDocument_hxx

#include <stdlib.h>
#include <stdio.h>
#include <xercesc/dom/DOMNode.hpp>
#include <xercesc/sax/ErrorHandler.hpp>
#include <xercesc/sax/SAXParseException.hpp>

class XDNode;

XERCES_CPP_NAMESPACE_USE

//////////////////////////////////////////////////////////////
class XDDocument : public ErrorHandler
{
public:
  XDDocument();
  ~XDDocument();

  // read data from an XML file - returns 0 on success - see getLastError()
  // if validate = true and there is a DTD file, the parser will
  //   check the XML file against the metadata in the DTD file
  int read(const char* filename, bool validate = true);

  // write out data to an XML file - returns 0 on success - see getLastError()
  // if validate is true and there is a DTD file, the file written out will be 
  //   read back in through the parser to see if it matches the DTD specification
  int write(const char* filename, bool validate = false);

  // get a text description of the last error from the read() or write() method
  // use this if you get a non-zero return value from either of these methods
  const char* getLastError() const;

  // write to an open FILE ptr - returns 0 on success - see getLastError()
  // useful for writing to stdout or stderr
  int write(FILE* fp);

  // set/get some XML file info
  const char* getFilename() const;
  void setDtdFilename(const char* filename);  // no DTD file by default
  const char* getDtdFilename() const;
  void setDtdName(const char* name);          // usually the same as the root node
  const char* getDtdName() const;
  void setVersion(const char* version);       // defaults to 1.0
  const char* getVersion() const;
  void setEncoding(const char* encoding);     // defaults to UTF-8
  const char* getEncoding() const;
  void setStandalone(const char* standalone); // defaults to yes
  const char* getStandalone() const;

  // get/set the root node for this document tree
  const XDNode* getRootNode() const;
  void setRootNode(XDNode* root);  // this deletes the old tree, if any

  // clear out any old trees and filenames
  void clear();

protected:

  // error handling for the DOM parser
  void warning(const SAXParseException& toCatch);
  void error(const SAXParseException& toCatch);
  void fatalError(const SAXParseException& toCatch);
  void resetErrors();

  void  initialize();
  void  deleteNode(XDNode* node);  // recursive delete
  void  setFilename(const char* filename);
  int   loadNode(DOMNode* dnode, XDNode* parent);
  void  writeNode(FILE* fp, const XDNode* node, short indentLevel);  // recursive write
  char* stripWhitespace(char* str);

  char*   _filename;
  char*   _dtdFilename;
  char*   _dtdName;
  char    _version[8];
  char    _encoding[16];
  char    _standalone[8];
  XDNode* _rootNode;
  char    _lastError[1024];
  char    _lastComment[1024];
  static  int _numObjects;
};


#endif

