#ifndef XDNode_hxx
#define XDNode_hxx

#include <stdlib.h>

class XDAttr;

//////////////////////////////////////////////////////////////
class XDNode
{
public:
  XDNode(const char* name, const char* value = NULL);
  ~XDNode();             // this deletes all attributes

  // name and value
  const char* getName() const;
  const char* getValue() const;
  void setName(const char* name);
  void setValue(const char* value);
  void setValue(double value);
  void setValue(float value);
  void setValue(int value);

  // this causes the text in the XML file to be wrapped with a
  // notation that indicates that the text should not be parsed
  // this is needed when special characters (<, >, &) are used
  void setValueWrapped(const char* value);
  bool isValueWrapped() const;

  // related nodes
  const XDNode* getParent() const;
  const XDNode* getFirstChild() const;
  const XDNode* getNextSibling() const;
  XDNode* appendChild(const char* name, const char* value = NULL);
  XDNode* appendSibling(const char* name, const char* value = NULL);
  XDNode* appendChildWrapped(const char* name, const char* value);
  XDNode* appendSiblingWrapped(const char* name, const char* value);

  const XDNode* getChild(const char* name) const;

  // attributes
  const XDAttr* getFirstAttr() const;
  const XDAttr* getAttr(const char* name) const;
  XDAttr* addAttr(const char* name, const char* value = NULL);

  // comment
  const char* getComment() const;
  void setComment(const char* comment);

protected:

  void initialize();
  XDNode* getLastChild() const;
  XDAttr* getLastAttr() const;

  char*   _name;
  char*   _value;
  char*   _comment;
  bool    _wrapValue;
  XDNode* _parent;
  XDNode* _firstChild;
  XDNode* _nextSibling;
  XDAttr* _firstAttr;
};

//////////////////////////////////////////////////////////////
class XDAttr
{
public:
  XDAttr(const char* name, const char* value = NULL);
  ~XDAttr();

  // name and value
  const char* getName() const;
  const char* getValue() const;
  void setName(const char* name);
  void setValue(const char* value);
  void setValue(double value);
  void setValue(float value);
  void setValue(int value);

  // was this attribute specified by the user in the XML file
  // Note that the attribute may be in the list even if the user didn't specify it if
  //  the attribute is specified as a non-optional attribute in the DTD file
  bool isSpecified() const;
  void setSpecified(bool specified);

  // next attribute
  const XDAttr* getNextAttr() const;

  friend class XDNode;

protected:

  void initialize();

  char*   _name;
  char*   _value;
  bool    _specified;
  XDAttr* _nextAttr;
};

#endif

