/*
Notice: This computer software was prepared by Brookhaven Science Associates, LLC and [individual author],
hereinafter the Contractor, under Contract DE-AC02-98CH10886 with the Department of Energy (DOE).
All rights in the computer software are reserved by DOE on behalf of the United States Government and the Contractor as
provided in the Contract. You are authorized to use this computer software for
Governmental purposes but it is not to be released or distributed to the public. NEITHER
THE GOVERNMENT NOR THE CONTRACTOR MAKES ANY WARRANTY,
EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS
SOFTWARE. This notice including this sentence must appear on any copies of this
computer software.
(End of Notice)
*/
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include <stdarg.h>
#define LINUX
#include "CAENVMElib.h"
#undef LINUX

void setupV102(long BHandle){

/* init module */
unsigned char init = 1;
unsigned char delay = 1;
unsigned char width = 10;
CAENVME_WriteCycle(BHandle,0xe641,&init,cvA16_U,cvD8);

/* set delay */
CAENVME_WriteCycle(BHandle,0xe64b,&delay,cvA16_U,cvD8);
                                                                                                                                   
/* set width */
CAENVME_WriteCycle(BHandle,0xe64d,&width,cvA16_U,cvD8);
                                                                                                                                   
}
                                                                                                                                   
void triggerV102(long BHandle){
                                                                                                                                   
/* init module */
unsigned char trig = 0x28;
CAENVME_WriteCycle(BHandle,0xe64e,&trig,cvA16_U,cvD8);
                                                                                                                                   
}

/* FIXME - this *must* correspond with the MODULE structue in xmlParse.cc and unpackData.c */
typedef struct {
  int numChans;
  int active; /* define active channels as well? */
  unsigned long blts;
  unsigned long addr;
  CVAddressModifier am;
  CVDataWidth dtsize;
  unsigned long *buff;
} module;

static void readV1290(char *addr){

  volatile unsigned short *pStatus = (unsigned short *) (addr+0x1002);
  volatile unsigned long *pData = (unsigned long *) addr;

  static const struct timespec waitTime = { 0, 16000 };

  for(;;){

    if(0 == ((*pStatus)&1)){ nanosleep(&waitTime, NULL); continue; }

    while(1 == ((*pStatus)&1)){
      volatile unsigned long val = *pData;

    }
  }
}

static void readV1729(char *base){
#if(0)
    for(j=0;j<(nSamp+3)*4;j+=2){
      int temp = readRegister(base, 0xd, 32);
      buf[j] += (temp >> 16);
      buf[j+1] += (temp & 0x0fff);
    }
  }
#endif
}

int runInterruptLoop(long BHandle, module *modules, int irq, unsigned int *incVal, const volatile unsigned int *incAddr, unsigned long maxEventsPerSpill, time_t timeLimit) 
{

  int j, nb;
  CVErrorCodes		ret = cvSuccess;
  unsigned char irqstat;

  setupV102(BHandle);
  CAENVME_IRQEnable(BHandle, (1<<(irq-1)));
  CAENVME_IRQCheck(BHandle,&irqstat);



  /* keep track of # of triggers */
  int events = 0;

  do {

#if(0)
    /* check for IRQ level 3 before doing BLT read - wait up to 10 seconds */
    for(j=0;j<10;j++){ ret = CAENVME_IRQWait(BHandle, (1<<(irq-1)), 5000); if(ret == cvSuccess)break;} 
    if(ret != cvSuccess){ return -1; }
    if(timeLimit > 0 && (time(0) > timeLimit)) return -1;
#else

    do { 
	CAENVME_IRQCheck(BHandle,&irqstat); 
	if(timeLimit > 0 && (time(0) > timeLimit)) return -1;
       } while (0 == (irqstat & (1<<(irq-1))));
#endif

    j = 0;
    for(j=0;modules[j].blts != 0;j++){

      if(!modules[j].active) continue;


      /* Some times the reading fails (for reasons not understood)
         Add some resiliency here... */

      { int retries = 20;
        do {

          /* FIXME - kludge to identify non-BLT devices - should be in module definition */
          if(modules[j].blts==8) { // timestamp
            clock_gettime(CLOCK_REALTIME, (struct timespec *) &modules[j].buff[ events*sizeof(struct timespec) / sizeof(modules[0].buff[0]) ]);
            nb = 8;
          }
          else if(modules[j].blts==64) { /* CAEN or SIS scaler */
            int k;
            nb = 0;
            for(k = 0; k < modules[j].blts/(sizeof(long)); k++){
              if(modules[j].active & 1<<k)
                ret = CAENVME_ReadCycle(BHandle,modules[j].addr+k*sizeof(long),(char *)&modules[j].buff[(modules[j].blts/sizeof(unsigned long))*events+k],cvA32_U_DATA,modules[j].dtsize);
              else {
                ret = cvSuccess; /* pretend we got data OK */
                modules[j].buff[(modules[j].blts/sizeof(unsigned long))*events+k] = 0;
                }
              if(ret == cvSuccess) nb += (sizeof(long));
              }
            }

          else
            ret = CAENVME_BLTReadCycle(BHandle,modules[j].addr,(char *)&modules[j].buff[(modules[j].blts/sizeof(unsigned long))*events],modules[j].blts,modules[j].am,modules[j].dtsize,&nb);

          if(ret) fprintf(stderr, "read error, ret = 0x%x\n", ret);
        } while(--retries > 0 && ret != 0);
      }

      if(nb != modules[j].blts) {
        fprintf(stderr, "error (0x%x) reading 0x%lx, asked for %ld bytes, received %ul bytes\n", ret, modules[j].addr, modules[j].blts, nb);
        return events;
      }

      if(ret != cvSuccess)
	switch (ret) {
	case cvBusError	 : 
	case cvCommError : 
	default          : 
	  return events;
	}

    } /* for loop */

    triggerV102(BHandle);

    /* reuse nb to hold incr value */

    /* for some reason, the SIS scaler sometimes reads back "-1" or some other bogus value,
       but never more than once in a row. Add some resiliency here... */
    { int retries = 20;
      do {
        ret = CAENVME_ReadCycle(BHandle,(unsigned long)incAddr,&nb,cvA32_U_DATA,cvD32);
        if(ret || nb == -1) fprintf(stderr, "nb = %d, ret = 0x%x\n", nb, ret);
        } while(--retries > 0 && (ret != 0 || abs(*incVal - nb) > 1));
    }

    events++;
  
  } while ( *incVal == nb && events < maxEventsPerSpill);

  *incVal = nb;

  return events;
}

typedef struct {

  /* default to previous values unless user overrides */
  char *ionSpecies;
  char *energy;
  char *users;
  
  /* these are unique for each data  collection period */
  char *comments;
  unsigned long date;
  time_t time;

  /* # of data points collected */
  unsigned long numberOfEvents;

  /* do not overwrite without explicit user consent */
  /* do something like add ".1", ".2", etc to previous name*/
  char *fileName;
} header;

int init(long *BHandle){

  CVBoardTypes  VMEBoard = cvV2718;
  short         Link = 0;
  short         Device = 0;
  
  int status = CAENVME_Init(VMEBoard, Device, Link, BHandle);

  return (status);

}

#ifdef STAND_ALONE
int main(int argc, const char *argv[]){
  long          BHandle;
  int           status;
  
  module modules[] = {
    
    
    /* list of active modules */
    { 1, 80,   0x3020000, cvA32_U_BLT, cvD32},
    { 1, 136,  0x3040000, cvA32_U_BLT, cvD32},
    { 1, 72,   0x3080000, cvA32_U_BLT, cvD32},
    { 1, 72,   0x30e0000, cvA32_U_BLT, cvD32},
    { 1, 4096, 0x2800000, cvA32_U_BLT, cvD32},
    { 0 }
    
  };

  /* scaler channel */
  static volatile const unsigned int *incrementAddr = (unsigned int *) 0x8383000;
  unsigned int increment;

  status = init(&BHandle);
  if( status != cvSuccess )
    {
      fprintf(stderr, "\n\n Error %d opening the device\n", status);
      exit(1);
    }
 
  CAENVME_ReadCycle(BHandle,(unsigned long) incrementAddr, &increment,cvA32_U_DATA,cvD32);
  
  runInterruptLoop(BHandle, modules, 3, &increment, incrementAddr);
  
  return(0);
}
#endif

