/*
Notice: This computer software was prepared by Brookhaven Science Associates, LLC and [individual author],
hereinafter the Contractor, under Contract DE-AC02-98CH10886 with the Department of Energy (DOE).
All rights in the computer software are reserved by DOE on behalf of the United States Government and the Contractor as
provided in the Contract. You are authorized to use this computer software for
Governmental purposes but it is not to be released or distributed to the public. NEITHER
THE GOVERNMENT NOR THE CONTRACTOR MAKES ANY WARRANTY,
EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS
SOFTWARE. This notice including this sentence must appear on any copies of this
computer software.
(End of Notice)
*/
#include <stdarg.h>
#define LINUX
#include "CAENVMElib.h"
#undef LINUX

/* MODULE should really be in a header file */
typedef struct {
  unsigned long numChannels; /* total # of channels */
  unsigned long activeChannels; /* no active channels means inactive module */
  unsigned long blts; /* # of bytes per "trigger" */
  unsigned long addr; /* VME address */
  CVAddressModifier am;
  CVDataWidth dtsize; /* width to read data into buffer */
  unsigned long *buff;
} MODULE;

#define CAEN_ADC_DATA_TYPE_MASK (0x7<<24)
#define CAEN_ADC_DATA_HEADER (0x2<<24)
#define CAEN_ADC_DATA_DATA (0<<24)
#define CAEN_ADC_DATA_EOB (0x4<<24)
#define CAEN_ADC_DATA_INVALID (0x6<<24)

#define CAEN_ADC_965_LOW_RANGE (1<<16)

#define CAEN_ADC_DATA_UNDER_RANGE (1<<13)
#define CAEN_ADC_DATA_OVER_RANGE (1<<12)
#define CAEN_ADC_DATA_NOT_VALID (1<<14)

#define CAEN_ADC_DATA_CHAN(word) ((word>>17)&0xf)
#define CAEN_ADC_DATA_DATA_MASK 0xfff
#define CAEN_ADC_DATA_COUNT_MASK 0xffffff

#define LOW_RANGE_THRESHOLD 3840

/* this algorithm was developed (and documented) in caenDrv.c */
void unpackCaenQDC(FILE *outputF, MODULE *module, unsigned long i){ 

  register int index, count, chan;
  register unsigned long val = module->buff[i*(module->blts/sizeof(unsigned long))];
  int data[32]; /* FIXME */

   /* is this really needed? */
  memset(data, 0, sizeof(data));

  int chanOffset = 0; // we need to figure out how many channels there are
  // CAEN left-justifies channel # in data (aaaargh), so we need to adjust
  switch(module->numChannels){
  case 16: chanOffset = 0; break;
  case  8: chanOffset = 1; break;
  case  4: chanOffset = 2; break;
  }

#if(0)
  fprintf(stderr, "unpacking QDC\n"); 

  fprintf(stderr, "header = 0x%x\n", val);
#endif

  if((val & CAEN_ADC_DATA_TYPE_MASK) != CAEN_ADC_DATA_HEADER){
fprintf(stderr, "val is not a header. val = 0x%x\n", val);
    for(index=0;index < 32 /* FIXME */; index++){
      if(module->activeChannels & 1<<index) { 
          fprintf(outputF,"NoData\t");
          fprintf(stdout, "NoData\t");
          }
      }
    return;
  }

  count = ((val>>8)&0x7f);

  for(index=0;index<=count;index++){
    val = module->buff[i*(module->blts/sizeof(unsigned long))+index+1];
    if((val & CAEN_ADC_DATA_TYPE_MASK) != CAEN_ADC_DATA_DATA)
      break; /* this is not data */

    chan = CAEN_ADC_DATA_CHAN(val); chan = chan>>chanOffset;

    if(val & (CAEN_ADC_965_LOW_RANGE<<chanOffset)){ /* got a "low range" value */
      
      /* if the low range did not overflow just use that, else shift up the high range, and ignore the low */
      if((val & CAEN_ADC_DATA_DATA_MASK) <= LOW_RANGE_THRESHOLD)
        data[chan] = (val & CAEN_ADC_DATA_DATA_MASK);
      else
        data[chan] =  data[chan]<<3; 
    } /* got a "low range" value */
  
    else { /* not a 965, or not a "low range", handle "normally"  */
      data[chan] = (val & CAEN_ADC_DATA_DATA_MASK);
    } /* not a "low range" */
  } /* for all channels */

  for(index=0;index < 32 /* FIXME */; index++){
    if(module->activeChannels & 1<<index) {
        fprintf(outputF, "%d\t", data[index]);
        fprintf(stdout,  "%d\t", data[index]);
        }
  } /* for all channels */

  if((val & CAEN_ADC_DATA_TYPE_MASK) != CAEN_ADC_DATA_EOB){
    return;
  }

#if(0)
  fprintf(stderr, "Success!\n");
#endif
}

/* Note : scaler values start at base address + 16(dec). */
/* For efficiency, we start reading the scaler at the data address,
   so we don't need the +16 offset here */
void unpackCaenScaler(FILE *outputF, MODULE *module, unsigned long i){ 

  register unsigned long index, val;

  for(index=0;index<16;index++){
    val = module->buff[i*(module->blts/sizeof(unsigned long))+index];
    if(module->activeChannels & 1<<index){
        fprintf(outputF, "%ld\t", val);
        fprintf(stdout,  "%ld\t", val);
        }
  }
}

#define DEBUG
void unpackCaenTDC(FILE *outputF, MODULE *module, unsigned long i){ 


  int index, chan;

  fprintf(stderr, "unpacking multi-hit TDC\n"); 

#if(0)
  for(index=0;index<60;index++){
    fprintf(stderr, "reading %d = 0x%x\n", i, module->buff[i*(module->blts/sizeof(unsigned long))+index]);
  }
#endif

    for(chan=0;chan<16;chan++){ /*FIXME - num channels*/
      /* what is recorded is "hits", not necessarily in channel order */
      /* we'll go through the data up to 8 times (if chan is enabled) */
      if(!(module->activeChannels & (1<<chan))) continue;

      fprintf(outputF, "[");
      fprintf(stdout,  "[");

      for(index=0;index<(1024/sizeof(long));index++){
	
	unsigned long val = module->buff[i*(module->blts/sizeof(unsigned long))+index];
	
	switch((val>>27)&0x1f){
	case 0x4:
#ifdef DEBUG
	  fprintf(stderr, "Error, flags = 0x%x\n", val&((1<<21)-1));
#endif
	  goto done;
	  break;
	  
	case 0:
#ifdef DEBUG
	  fprintf(stderr, "channel[%d] = %d%s\n", (val>>21)&0x1f, val&((1<<21)-1), (val&1<<26)?"(trailing)":"");
#endif
	  {
	    int dataChan = (val>>21)&0x1f;
	    if(chan==dataChan) {
                fprintf(outputF, "%ul\t", val&((2<<21)-1));
                fprintf(stdout,  "%ul\t", val&((2<<21)-1));
                }
	  }
	  break;
	  
	case 0x18:
#ifdef DEBUG
	  fprintf(stderr, "No data\n");
#endif
	  goto done;
	  break;
	  
	  
	default:
#ifdef DEBUG
	  fprintf(stderr, "Unknown: 0x%x\n", val);
#endif
	  goto done;
	  break;
	} /* switch */
      } /* hits */
done:
      fprintf(outputF, "]\t");
      fprintf(stdout,  "]\t");
    } /* channels */
}

#define NUM_CHANS 4
static unsigned short calData[NUM_CHANS*2560];

void initUnpackFuncs(MODULE *module){

    FILE *calFile = fopen("calibrate", "r");
    if(calFile){
        int i;
        for(i=3*NUM_CHANS;i<2560*NUM_CHANS;i++){
          (void) fscanf(calFile, "%i", &calData[i]);
          }
    }

}

void unpackCaenFADC(FILE *outputF, MODULE *module, unsigned long i){ 

  int index;

  // FIXME - this module needs special treat - taking a backgroun measurement
  fprintf(stderr, "unpacking FADC\n"); 

  for(index=0;index<40;index++){
    fprintf(stderr, "reading %d = 0x%x\n", i, module->buff[i*(module->blts/sizeof(unsigned long))+index]);
  }
}

