// package nsrlDataAcquisition;

public class CircularBuffer
{
	public CircularBuffer(int sizeIn)
	{
		size = sizeIn;
		array = new Object[size];
		arraySize = 0;
		start = 0;
		end = -1;
		translatedStart = 0;  //the number of entries have been override with new entries 
		totalElementsAdded = 0; //the total number of entries added
		currentSize = 0;
		notFull = true;  //when this is false, the "size=totalElementsAdded -translatedStart"
	}

	public void put(Object objectIn)
	{
		totalElementsAdded++;  //what it means if this number exceeds the size ---i.e. the max size of the array?  
		
		if (notFull) // we still have room!
		{
			end++;
			currentSize++;
			array[end] = objectIn;
			if (end == (size - 1))
				notFull = false;
		}
		else // we must move circular buffer around
		{
			array[start] = objectIn;
			start++;
			start %= size;
			end++;
			end %= size;
			translatedStart++;
		}

	}

	public Object get(int index)
	{
		// check for index greater than size....

		index += start;
		index %= size;
		return array[index];
	}

	// how many times we had to move the "start" pointer
	public int getTranslatedStart()
	{
		return translatedStart;
	}

	public int getTotalElementsAdded()
	{
		return totalElementsAdded;
	}

	public int getCurrentSize()
	{
		return currentSize;
	}

	private int size, arraySize, start, end, translatedStart,
			totalElementsAdded, currentSize;
	private boolean notFull;
	private Object[] array;
}
