/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
// package nsrlDataAcquisition;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/**
 * GUI panle which displays and maintains all the information associated with a nsrlDataAcquisition Configuration
 * 
 * @author pucci
 */
public class ConfigurationPane extends JPanel
{

	public ConfigurationPane()
	{
		super();

		// _fileName = "";
		_dirty = false;

		setLayout(new BorderLayout());
		JPanel mainHolder = new JPanel();
		mainHolder.setLayout(new GridBagLayout());
		mainHolder.setBorder(BorderFactory.createCompoundBorder(BorderFactory
				.createTitledBorder("Configuration Information"), BorderFactory
				.createEmptyBorder(10, 30, 20, 30)));

		/* Constraint to control the Left side label */
		GridBagConstraints cLabel = new GridBagConstraints();
		/* Constraint to control the right side field */
		GridBagConstraints cField = new GridBagConstraints();
		/* KeyListener to listen for input and set the _dirty flag */
		DirtyInputListener eventListener = new DirtyInputListener();

		/* Add the components alternating constraints */
		cLabel.anchor = GridBagConstraints.FIRST_LINE_START;
		cLabel.gridx = 0;
		cLabel.gridy = 0;
		cLabel.insets = new Insets(0, 5, 5, 0);
		cLabel.fill = GridBagConstraints.VERTICAL;
		mainHolder.add(new JLabel("File Name: "), cLabel);

		cField.gridx = 1;
		cField.gridy = 0;
		cField.fill = GridBagConstraints.BOTH;
		cField.weightx = 1.0;
		cField.weighty = 1.0;
		cField.gridwidth = 3;
		cField.insets = new Insets(0, 5, 5, 0);
		_fileName = new JTextField("");
		_fileName.setEditable(false);
		mainHolder.add(_fileName, cField);

		cLabel.gridy++;
		cLabel.anchor = GridBagConstraints.LINE_START;
		mainHolder.add(new JLabel("Configuration Name: "), cLabel);
		cField.gridy++;
		_configurationName = new JTextField(DEFAULT_CONFIG_NAME);
		_configurationName.setForeground(Color.red);
		_configurationName.addKeyListener(eventListener);
		mainHolder.add(_configurationName, cField);

		cLabel.gridy++;
		// cLabel.anchor = GridBagConstraints.LINE_START;
		mainHolder.add(new JLabel("Users: "), cLabel);
		cField.gridy++;
		_users = new JTextArea(4, 15);
		_users.addKeyListener(eventListener);
		mainHolder.add(new JScrollPane(_users), cField);

		cLabel.gridy++;
		mainHolder.add(new JLabel("Ion Species: "), cLabel);
		cField.gridy++;
		_ionSpecies = new JTextField(15);
		_ionSpecies.addKeyListener(eventListener);
		mainHolder.add(_ionSpecies, cField);

		cLabel.gridy++;
		mainHolder.add(new JLabel("Energy: "), cLabel);
		cField.gridy++;
		_energy = new JTextField(15);
		_energy.addKeyListener(eventListener);
		mainHolder.add(_energy, cField);

		cLabel.gridy++;
		mainHolder.add(new JLabel("# of Events: "), cLabel);
		cField.gridy++;
		_numEvents = new JTextField(15);
		_numEvents.addKeyListener(eventListener);
		mainHolder.add(_numEvents, cField);

		cLabel.gridy++;
		mainHolder.add(new JLabel("Timeout (sec): "), cLabel);
		cField.gridy++;
		_timeOut = new JTextField(15);
		_timeOut.addKeyListener(eventListener);
		mainHolder.add(_timeOut, cField);

		cLabel.gridy++;
		mainHolder.add(new JLabel("Comments: "), cLabel);
		cField.gridy++;
		_comments = new JTextArea(4, 15);
		_comments.setWrapStyleWord(true);
		_comments.addKeyListener(eventListener);
		mainHolder.add(new JScrollPane(_comments), cField);

		add(mainHolder, BorderLayout.CENTER);

		this.setMinimumSize(MIN_SIZE);
	}

	/**
	 * Get all the data inside on this pane.
	 * 
	 * @return Hashmap containing <String, String> mappings of configuration data to ConfigurationPane text fields.
	 */
	public HashMap<String, String> getAllPaneData()
	{
		HashMap<String, String> paneData = new HashMap<String, String>();

		paneData.put(CONFIG_FILE_NAME, this._fileName.getText());
		paneData.put(CONFIG_NAME_FIELD, _configurationName.getText());
		try
		{
			paneData.put(USERS_FIELD, _users.getText());
		}
		catch (NullPointerException npe)
		{
			paneData.put(USERS_FIELD, "");
		}
		paneData.put(OUTPUT_FILE_FIELD, _outputFile);

		paneData.put(ION_SPECIES_FIELD, _ionSpecies.getText());
		paneData.put(ENERGY_FIELD, _energy.getText());
		paneData.put(NUM_EVENTS_FIELD, _numEvents.getText());
		paneData.put(TIME_OUT_FIELD, _timeOut.getText());
		try
		{
			paneData.put(COMMENTS_FIELD, _comments.getText());
		}
		catch (NullPointerException npe)
		{
			paneData.put(COMMENTS_FIELD, "");
		}

		return paneData;
	}

	/**
	 * Set all the data on this pane
	 * 
	 * @param paneData
	 *            -- HashMap<String, String> representing the new data.
	 */
	public void setAllPaneData(HashMap<String, String> paneData)
	{

		if (paneData.containsKey(CONFIG_FILE_NAME))
		{
			this._fileName.setText(paneData.get(CONFIG_FILE_NAME));
		}
		else
		{
			this._fileName.setText("");
		}

		if (paneData.containsKey(CONFIG_NAME_FIELD))
		{
			this._configurationName.setText(paneData.get(CONFIG_NAME_FIELD));
		}
		else
		{
			this._configurationName.setText("");
		}

		if (paneData.containsKey(USERS_FIELD))
		{
			_users.replaceRange(paneData.get(USERS_FIELD), 0, _users
					.getDocument().getLength());
			_users.setCaretPosition(0);
		}
		else
		{
			_users.replaceRange("", 0, _users.getDocument().getLength());
		}

		if (paneData.containsKey(OUTPUT_FILE_FIELD))
		{
			_outputFile = paneData.get(OUTPUT_FILE_FIELD);
		}
		else
		{
			_outputFile = "";
		}

		if (paneData.containsKey(ION_SPECIES_FIELD))
		{
			_ionSpecies.setText(paneData.get(ION_SPECIES_FIELD));
		}
		else
		{
			_ionSpecies.setText("");
		}

		if (paneData.containsKey(ENERGY_FIELD))
		{
			_energy.setText(paneData.get(ENERGY_FIELD));
		}
		else
		{
			_energy.setText("");
		}

		if (paneData.containsKey(NUM_EVENTS_FIELD))
		{
			_numEvents.setText(paneData.get(NUM_EVENTS_FIELD));
		}
		else
		{
			_numEvents.setText("");
		}

		if (paneData.containsKey(TIME_OUT_FIELD))
		{
			_timeOut.setText(paneData.get(TIME_OUT_FIELD));
		}
		else
		{
			_timeOut.setText("");
		}

		if (paneData.containsKey(COMMENTS_FIELD))
		{
			_comments.replaceRange(paneData.get(COMMENTS_FIELD), 0, _comments
					.getDocument().getLength());
			_comments.setCaretPosition(0);
		}
		else
		{
			_comments.replaceRange("", 0, _comments.getDocument().getLength());
		}
	}

	/**
	 * Reset this pane so that all data is empty and GUI is empty.
	 */
	public void clear()
	{

		_dirty = false;
		_fileName.setText(""); 
		_configurationName.setText(DEFAULT_CONFIG_NAME);
		_outputFile = "";
		_users.replaceRange("", 0, _users.getDocument().getLength());
		_ionSpecies.setText("");
		_energy.setText("");
		_numEvents.setText("");
		_timeOut.setText("");
		_comments.replaceRange("", 0, _comments.getDocument().getLength());

	}

	public void setConfiguration(String name)
	{
		this._configurationName.setForeground(Color.BLUE);
		this._configurationName.setText(name);
	}

	public String getConfigName()
	{
		/*
		 * if (this._configurationName.getText().equals(DEFAULT_CONFIG_NAME)) { return ""; }
		 */
		return this._configurationName.getText();
	}

	public String getFileName()
	{
		return this._fileName.getText();
	}

	public void setFileName(String file)
	{
		this._fileName.setText(file);
	}

	public boolean isDirty()
	{
		return this._dirty;
	}

	public String getEnergy()
	{
		return _energy.getText();
	}

	public void setEnergy(String _energy)
	{
		this._energy.setText(_energy);
	}

	public String getIonSpecies()
	{
		return _ionSpecies.getText();
	}

	public void setIonSpecies(String _ionSpecies)
	{
		this._ionSpecies.setText(_fileName.getText());
	}

	public String getNumEvents()
	{
		return _numEvents.getText();
	}

	public void setNumEvents(String _numEvents)
	{
		this._numEvents.setText(_numEvents);
	}

	public String getTimeOut()
	{
		return _timeOut.getText();
	}

	public void setTimeOut(String _timeOut)
	{
		this._timeOut.setText(_timeOut);
	}

	public String getComments()
	{
		String temp = _comments.getText();
		if (temp.length() > 0)
			temp = temp.replace("\n", "\n#");
		return temp;
	}

	private class DirtyInputListener implements KeyListener
	{

		public void keyPressed(KeyEvent e)
		{

		}

		public void keyReleased(KeyEvent e)
		{

		}

		public void keyTyped(KeyEvent e)
		{
			// if(!_dirty)
			{
				/* Bubble the event up to the EventDispatcher */
				EventDispatcher.getInstance()
						.fireEvent(
								new ActionEvent(e.getSource(),
										ActionEvent.ACTION_PERFORMED,
										KEY_TYPED_COMMAND));
				_dirty = true;
			}

		}

		public void caretPositionChanged(InputMethodEvent event)
		{
		}

		public void inputMethodTextChanged(InputMethodEvent event)
		{
		}
	}

	public static final String OPEN_CONFIG_COMMAND = "OPEN_CONFIG";
	public static final String SAVE_CONFIG_COMMAND = "SAVE_CONFIG";
	public static final String OUTPUT_FILE_COMMAND = "SELECT_OUTPUT";
	public static final String CONFIG_NAME_FIELD = "CONFIG";
	public static final String OUTPUT_FILE_FIELD = "OUTPUT";
	public static final String DATE_TIME_FIELD = "DATE_TIME";
	public static final String COMMENTS_FIELD = "COMMENTS";
	public static final String NUM_EVENTS_FIELD = "NUM_EVENTS";
	public static final String TIME_OUT_FIELD = "TIME_OUT";
	public static final String USERS_FIELD = "USERS";
	public static final String ENERGY_FIELD = "ENERGY";
	public static final String ION_SPECIES_FIELD = "ION_SPECIES";
	public static final String CONFIG_FILE_NAME = "FILE_NAME";
	public static final String DEFAULT_CONFIG_NAME = "New_Configuration_(Unsaved)";
	public static final String KEY_TYPED_COMMAND = "KEY_TYPED";

	public static final long serialVersionUID = 1L;

	private JButton _selectButton;
	private JFrame _mainFrame;
	private JTextField _configurationName;
	private JTextField _fileName;
	private JTextField _dateTime;
	private JTextArea _comments;
	private String _outputFile;
	private JTextField _numEvents;
	private JTextField _timeOut;
	private JTextArea _users;
	private JTextField _energy;
	private JTextField _ionSpecies;
	private JButton _openConfigBut;
	private JButton _saveConfigBut;
	// private String _fileName;
	private boolean _dirty;
	public static final Dimension MIN_SIZE = new Dimension(474, 270);
}
