/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

// package nsrlDataAcquisition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

/**
 * Singleton class used to dispatch all action events to every ActionListener.
 * Also needed for the bubbling up of events to outer classes.
 * 
 * 
 */
public class EventDispatcher implements ActionListener{

    private EventDispatcher(){
        _listeners = new Vector<ActionListener>();
    }
    
    public static synchronized EventDispatcher getInstance(){
        if (_instance == null)
            _instance = new EventDispatcher();
            
        return _instance;
    }
    
    public void addActionListener(ActionListener listener){
        this._listeners.add(listener);
    }
    
    public void actionPerformed(ActionEvent e) {
        
        /* dispatch the event to each listener */
        for (int i=0; i<_listeners.size(); i++){
            _listeners.get(i).actionPerformed(e);
        }
    }
    
    /**
     * Helper method so that other non ActionListeners may notify this main listener
     * This is used for bubbling events up from lower classes to upper classes.
     * @param e
     */
    public void fireEvent(ActionEvent e){
        this.actionPerformed(e);
    }

    private Vector<ActionListener> _listeners;
    private static EventDispatcher _instance = null;
    
}
