// package nsrlDataAcquisition;

//import javax.swing.UIManager;
//import javax.swing.UIManager.LookAndFeelInfo;
import javax.swing.SwingUtilities;
import java.lang.Runnable;

//////////////////////////////////////////////////////////////////////////////////////
public class Main implements Runnable
{

    protected static boolean _dataWin = false;
    protected static String _configFile = null;
    public static int MODE = Constants.NSRL;
    
    Main(String[] args)
    {
    }

    public static void main(String[] args)
    {
        for (int i = 0; i < args.length; i++)
        {
            if (args[i].equals("-data"))
            {
                _dataWin = true;
            }
            else
            {
                if (args[i].equals("-conf"))
                {
                    _configFile = args[i + 1];
                }
                else
                {
                    if (args[i].equals("-mode"))
                    {
                        if (args[i + 1].equals("zdc"))
                        {
                            MODE = Constants.ZDC;
                        }
                    }
                    else
                    {
                        if (args[i].equals("-h"))
                        {
                            System.err.println("\nusage : nsrlDataAcquisition [options]\n");
                            System.err.println("options:");
                            System.err.println("-h                      help.");
                            System.err.println("-data                starts a data window for the currently running configuration.");
                            System.err.println("-conf                starts the program with the specified configuration file.");
                            System.err.println("-mode                specify which mode of operation.  Defaults to NSRL valid option is 'zdc'");
                            System.err.println("");
                            exit(1);
                        }
                    }
                }
            }
        }
        SwingUtilities.invokeLater(new Main(args));  // to avoid swing thread safety issues
    }

    //invoke the GUI setup in this event-dispatching thread
    public void run()
    {
        if (_dataWin)
        {
            try
            {
                String outputFile = XmlUtils.getInstance().getConfigOuputFile();
                if (outputFile == null || outputFile == "")
                {
                    System.out.println("No data file could be found.");
                    exit(1);
                }
                else
                {
                    System.out.println("Data file found: " + outputFile + ", starting data window...");
                    DataConsoleThreaded data = new DataConsoleThreaded(null, outputFile,
                            XmlUtils.getInstance().getRunColumnNames());
                    //data.setVisible(true);
                    //data.pack();
                }
            }
            catch (Exception ex)
            {
                System.out.println("There is currently no running configuration, exiting...");
            }
        }
        else
        {
            try
            {
                String title = "NSRL Data Acquisition";
                if (MODE == Constants.ZDC)
                {
                    title = "ZDC Data Acquisition";
                }
                MainFrame frame = new MainFrame(title,
                        XmlUtils.getInstance().loadModuleConfig(_configFile));
                frame.setVisible(true);
                frame.pack();
            }
            catch (Exception ex)
            {
                System.out.println("Exception: " + ex);
                ex.printStackTrace();
                System.out.println("Critical Error: could not read nsrlDataAcquisition.conf file.");
                System.out.println(ex.getMessage());
            }
        }
    }

    public static void exit(int status)
    {
        System.exit(status);
    }

}