// package nsrlDataAcquisition;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Date;
import java.text.SimpleDateFormat;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

// import gov.bnl.cad.swing.MessageArea;
// import gov.bnl.cad.swing.HelpMenu;

import java.text.NumberFormat;
import java.text.ParseException;

import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
// import gov.bnl.cad.swing.*;
//import gov.bnl.cad.swing.XFrame;


/**
 * 
 * @author: created by pucci before 2007
 * 
 * Last updated 04-05/2011 by Wenge
 *      * Add support time stamp
 *      * Handle very large data set
 * Last updated 09/2011 by Wenge
 *      * Add support to change channel names, 
 *      * display channel names on GUI, 
 *      * save channel names and comment in data files
 *       
 */
public class MainFrame extends JFrame {

	
	/**
	 * Construct a new MainFrame object
	 * 
	 * @param title
	 *            -- the frame title
	 * @param panels
	 *            -- the Vector<ModulePane> which contain the ModulePane's in the nsrlDataAcquisition.conf file.
	 */
	public MainFrame(String title, Vector<ModulePane> panels)
	{
		super(title);
		_panels = panels;
		init();
	}

	
	/**
	 * Build the gui
	 */
	private void init()
	{
            DEFAULT_DIR = System.getProperty("user.dir") + "/";
            DEFAULT_DATA_DIR = DEFAULT_DIR + "data/";

		/* Setup some datastructures and our Xml Utilities class, */
		// _panels = new Hashtable<String, ModulePane>();

		/*
		 * Get the client screen size in order to attempt a better fit then set the size for this frame
		 */
		int sz = (int) (_panels.size() * (ModulePane.MAX_SIZE).getWidth());
		if (_panels.size() < 5)
			// don't make the window so small that the bottom panel gets truncated
			sz = (int) (5 * (ModulePane.MAX_SIZE).getWidth());
		_screenSize = new Dimension(sz, 747);

		// this.setMinimumSize(_screenSize);
		this.setPreferredSize(_screenSize);
		this.setSize(_screenSize);

		// Create the GeneralActionListener inner class
		EventDispatcher.getInstance().addActionListener(
				new GeneralActionListener());
		ActionListener eventListener = EventDispatcher.getInstance();

		_dirty = false;
		_newconfig = true;
		_nowAcquiring = false;

		/*
		 * Now build the JMenuBar for this frame There is no need to maintain an instance var for the panel since we can
		 * always get the object from the this.getJMenuBar
		 */
		JMenuBar topMenu = new JMenuBar();
		JMenu fileMenu = new JMenu("File");
		fileMenu.setMnemonic(KeyEvent.VK_F);
		fileMenu.setActionCommand(FILE_MENU);
		// fileMenu.addMenuListener(new FileMenuListener());

		/* creates a new empty file */
		_newConfigItem = new JMenuItem("New", KeyEvent.VK_N);
		_newConfigItem.addActionListener(eventListener);
		_newConfigItem.setAccelerator(KeyStroke.getKeyStroke("ctrl N"));
		_newConfigItem.setActionCommand(NEW_CONFIG_COMMAND);
		fileMenu.add(_newConfigItem);

		fileMenu.add(new JSeparator());
		/* open item which opens a new file */
		_openItem = new JMenuItem("Open...", KeyEvent.VK_O);
		_openItem.setAccelerator(KeyStroke.getKeyStroke("ctrl O"));
		_openItem.setActionCommand(OPEN_CONFIG_COMMAND);
		_openItem.addActionListener(eventListener);
		fileMenu.add(_openItem);

		/* save the current file */
		_saveItem = new JMenuItem("Save", KeyEvent.VK_S);
		_saveItem.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
		_saveItem.setActionCommand(SAVE_CONFIG_COMMAND);
		_saveItem.addActionListener(eventListener);
		_saveItem.setEnabled(false);
		fileMenu.add(_saveItem);

		/* save the current file as... */
		_saveAsItem = new JMenuItem("Save As...");
		_saveAsItem.setActionCommand(SAVE_AS_CONFIG_COMMAND);
		_saveAsItem.addActionListener(eventListener);
		fileMenu.add(_saveAsItem);

		fileMenu.add(new JSeparator());

		/* exit the app */
		_quitItem = new JMenuItem("Quit", KeyEvent.VK_Q);
		_quitItem.setAccelerator(KeyStroke.getKeyStroke("ctrl Q"));
		_quitItem.setActionCommand(APPLICATION_QUIT_COMMAND);
		_quitItem.addActionListener(eventListener);
		fileMenu.add(_quitItem);

		topMenu.add(fileMenu);
		topMenu.add(Box.createHorizontalGlue());
		/* setup the menu bar */
// 		HelpMenu helpMenu = new HelpMenu(this, new AppBuildInfo());
// 		try
// 		{
// 			helpMenu.setOverviewFile();
// 		}
// 		catch (Exception ex)
// 		{
// 			// ex.printStackTrace();
// 			System.out.println(ex.getMessage());
// 		}
// 		try
// 		{
// 			helpMenu.setReleaseInfo();
// 		}
// 		catch (Exception ex)
// 		{
// 			// ex.printStackTrace();
// 			System.out.println(ex.getMessage());
// 		}
// 		topMenu.add(helpMenu);
		setJMenuBar(topMenu);

		// Create our module layer, this will hold all the ModulePanels
		_moduleLayer = new JPanel();
		_moduleLayer.setLayout(new GridLayout(1, 0));
		_moduleLayer.setBackground(new Color(109, 109, 109));
		if (_panels.size() < 5)
		{
			// try to make the spacing and size of window pleasing
			int borderGap = 25;
			switch (_panels.size())
			{
			case 1:
				borderGap *= 7;
				break;
			case 2:
				borderGap *= 6;
				break;
			case 3:
				borderGap *= 4;
				break;
			case 4:
				borderGap *= 3;
				break;
			}
			_moduleLayer.setBorder(BorderFactory.createEmptyBorder(10,
					borderGap, 10, borderGap));
		}
		else
			_moduleLayer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10,
					10));
		_moduleLayer.setMinimumSize(new Dimension((int) _screenSize.getWidth(),
				ModulePane.MAX_SIZE.height + 10));
		_moduleLayer.setPreferredSize(_moduleLayer.getMinimumSize());
		_moduleLayer.setSize(_moduleLayer.getPreferredSize());

		/*
		 * These module panels were read-in in the main method and passed to thisconstructor. They are read from the
		 * nsrlDataAcquisition.conf file.
		 */
		Enumeration<ModulePane> modules = _panels.elements();
		while (modules.hasMoreElements())
		{
			_moduleLayer.add(modules.nextElement());
		}

		/* Add the side buttons to control the data capture */
		JPanel buttonsPanel = new JPanel();
		JPanel buttonsTopPanel = new JPanel();
		buttonsTopPanel.setMaximumSize(new Dimension(200, 161));

		BoxLayout buttonPanelLayout = new BoxLayout(buttonsPanel,
				BoxLayout.Y_AXIS);
		buttonsPanel.setLayout(buttonPanelLayout);

		GridLayout buttonTopLayout = new GridLayout(0, 1);
		buttonTopLayout.setHgap(10);
		buttonTopLayout.setVgap(10);
		buttonsTopPanel.setLayout(buttonTopLayout);
		buttonsTopPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		_startCapture = new JButton("Start Capture");
		_startCapture.setActionCommand(START_CAPTURE_COMMAND);
		_startCapture.addActionListener(eventListener);
		_endCapture = new JButton("End Capture");
		_endCapture.setActionCommand(END_CAPTURE_COMMAND);
		_endCapture.setEnabled(false);
		_endCapture.addActionListener(eventListener);
		_dataConsole = new JButton("Start Data Console");
		_dataConsole.setActionCommand(START_DATA_CONSOLE_COMMAND);
		_dataConsole.setEnabled(false);
		_dataConsole.addActionListener(eventListener);
		_analyzeButton = new JButton("Analyze");
		_analyzeButton.setActionCommand(ANALYZE);
		// _analyzeButton.setEnabled(false);
		_analyzeButton.addActionListener(eventListener);
		_runningStatus = new JLabel("Acquiring...", SwingConstants.CENTER);
		_runningStatus.setVisible(false);
		Font font = new Font("Dialog", Font.BOLD, 18);
		if (font != null)
		{
			_runningStatus.setFont(font);
		}
		buttonsTopPanel.add(_startCapture);
		buttonsTopPanel.add(_endCapture);
		buttonsTopPanel.add(_dataConsole);
		buttonsTopPanel.add(_analyzeButton);
		buttonsTopPanel.add(Box.createVerticalStrut(10));
		buttonsTopPanel.add(_runningStatus);

		/*
		 * Layout it out nicely, This pushes the next panel all the way to the bottom of this side panel.
		 */
		buttonsPanel.add(Box.createVerticalStrut(10));
		buttonsPanel.add(buttonsTopPanel);
		buttonsPanel.add(Box.createVerticalGlue());

		JPanel buttonsBottomPanel = new JPanel();
		buttonsBottomPanel.setMaximumSize(new Dimension(200, 161));
		buttonsBottomPanel.setBorder(BorderFactory
				.createEmptyBorder(5, 5, 5, 5));
		GridLayout buttonBottomLayout = new GridLayout(0, 1);
		buttonBottomLayout.setHgap(10);
		buttonBottomLayout.setVgap(10);
		buttonsBottomPanel.setLayout(buttonBottomLayout);

		JButton openConfig = new JButton("Open Config");
		openConfig.setActionCommand(OPEN_CONFIG_COMMAND);
		openConfig.addActionListener(eventListener);

		_saveConfig = new JButton("Save Config");
		_saveConfig.setActionCommand(SAVE_CONFIG_COMMAND);
		_saveConfig.addActionListener(eventListener);
		_saveConfig.setEnabled(false);

		buttonsBottomPanel.add(openConfig);
		buttonsBottomPanel.add(_saveConfig);

		buttonsPanel.add(buttonsBottomPanel);

		/* Create the ConfigurationPane */
		_headerInfo = new ConfigurationPane();

		JPanel bottomContent = new JPanel();
		bottomContent.setLayout(new BorderLayout());
		bottomContent.add(_headerInfo, BorderLayout.CENTER);
		bottomContent.add(buttonsPanel, BorderLayout.EAST);

		// JSplitPane in order to add some logical flow to the layout
		// This adds the bnl message area to the bottom of the mainFrame.
		_messageArea = new MessageArea(10);
		// _messageArea.append("default configuration loaded successfully."); //don't know why Ben said this, no config
		// was loaded!
		JScrollPane messageScroller = new JScrollPane(_messageArea);
		messageScroller.setMinimumSize(new Dimension(10, 50));

		JSplitPane bottomSplit = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				bottomContent, messageScroller);
		bottomSplit.setDividerSize(5);
		bottomSplit.setResizeWeight(0);

		JSplitPane jsplit = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				_moduleLayer, bottomSplit);
		jsplit.setDividerSize(5);
		jsplit.setResizeWeight(1);
		jsplit.setPreferredSize(this.getPreferredSize());

		// Add our components and setup the close operation
		this.add(jsplit);
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		this.addWindowListener(new MainWindowAdapter());
		this.setLocationByPlatform(true);

		// request by Mike, open latest config file automatically -MPM
		if (DEFAULT_TO_LATEST_CONFIG)
			loadLatestConfig();
	}
    
    
    
	/**
	 * Checks directory and finds file with most current date and attempts to load
	 * 
	 * @return true if successful, false otherwise
	 */
	private boolean loadLatestConfig()
	{
		String dir;
// 		if (Main.MODE == Constants.ZDC)
// 			dir = DEFAULT_DIR + "config/" + "zdc/";
// 		else if (Main.MODE == Constants.NSRL)
// 			dir = DEFAULT_DIR + "config/" + "nsrl/";
// 		else
			dir = DEFAULT_DIR + "config/";

		File configDir = new File(dir);
		if (configDir.isDirectory())
		{
			File[] ls = configDir.listFiles();

			int lastModified = -1;
			long lastModTime = 0;
			if (ls != null)
			{
				for (int i = 0; i < ls.length; i++)
				{
					if (ls[i].lastModified() > lastModTime)
					{
						lastModTime = ls[i].lastModified();
						lastModified = i;
					}
				}
			}

			if (lastModified != -1)
			{
				try
				{
					// we need to clear all the current panels
					_headerInfo.clear();
					clear(true);

					_headerInfo.setAllPaneData(XmlUtils.getInstance()
							.loadXMLIntoHeader(
									ls[lastModified].getAbsolutePath()));

					XmlUtils.getInstance().loadXMLIntoModules(
							ls[lastModified].getAbsolutePath(), _panels);

					addMessage("Latest config file "
							+ ls[lastModified].getAbsolutePath()
							+ " loaded successfully.");
					return true;

				}
				catch (org.jdom.JDOMException jde)
				{
					addMessage("There was an error loading the latest config file: "
							+ ls[lastModified].getAbsolutePath());
					System.out.println(jde.getMessage());
					return false;
				}
				catch (java.io.IOException ioe)
				{
					addMessage("Error: The latest config file "
							+ ls[lastModified].getAbsolutePath()
							+ " could not be found."); // this really shouldn't happen
					System.out.println(ioe.getMessage());
					return false;
				}
			}
			else
			// couldn't find last modified file
			{
				addMessage("Error: couldn't determine latest configuration file, so could not load.");
				return false;
			}
		}
		else
		// configDir was not a directory (shouldn't happen)
		{
			addMessage("Error: couldn't load latest config since "
					+ configDir.getAbsolutePath() + " is not a valid directory");
			return false;
		}
	}

	
	
	
	/**
	 * Clear all selected channels from the ModulePanes
	 */
	private void clearAllModulePanels()
	{
		Enumeration<ModulePane> elements = _panels.elements();

		while (elements.hasMoreElements())
		{
			elements.nextElement().clear();
		}
	}

	/**
	 * Exit the program with or without prompting for confirmation
	 * 
	 * @param diag
	 *            boolean to specify whether to show exit confirmation dialog.
	 */
	private void exit(boolean diag)
	{
		if (diag)
		{
			int close = JOptionPane.showConfirmDialog(this,
					"Are you sure you wish to exit?", "Exit Confirmation",
					JOptionPane.YES_NO_OPTION);

			if (close == JOptionPane.YES_OPTION)
			{
				/* incase we are still running the capture for some reason */
				if (_daqProcess != null)
				{
					_daqProcess.destroy();
				}
				Main.exit(0);
			}
		}
		else
		{
			/* incase we are still running the capture for some reason */
			if (_daqProcess != null)
			{
				_daqProcess.destroy();
			}
			Main.exit(0);
		}
	} 
    
	
	

	/**
	 * Clear() method used to reset everything in the GUI or just the GUI state back to init state.
	 */
	private void clear(boolean stateAndGui)
	{

		// Then just clear the state
		if (!stateAndGui)
		{
			_dirty = false;
			_startCapture.setEnabled(true);
			_endCapture.setEnabled(false);
			_dataConsole.setEnabled(false);
			_saveItem.setEnabled(false);
			_saveConfig.setEnabled(false);
		}
		else
		{
			_dirty = false;
			_startCapture.setEnabled(true);
			_endCapture.setEnabled(false);
			_dataConsole.setEnabled(false);
			_saveItem.setEnabled(false);
			_saveConfig.setEnabled(false);
			Enumeration<ModulePane> elements = _panels.elements();
			while (elements.hasMoreElements())
			{
				(elements.nextElement()).clear();
			}
		}
	}

	
	
	public void endCapture()
	{
		// Simulate that we clicked the End Capture button
		EventDispatcher.getInstance().fireEvent(
				new ActionEvent(_endCapture, 1, END_CAPTURE_COMMAND));
		JOptionPane.showMessageDialog(this,
				"Data Acquisition Process has ended normally.",
				"Process Finished", JOptionPane.INFORMATION_MESSAGE);
	}

	
	
    /**
     * this class read source data file with stream and store the data into
     * a CircularBuffer object
     * 
     *
     */

	public class StreamGobbler extends Thread
	{
		InputStream is;
		String type;

		StreamGobbler(InputStream is, String type)
		{
			this.is = is;
			this.type = type;
		}

		public void run()
		{
			try
			{
				InputStreamReader isr = new InputStreamReader(is);
				BufferedReader br = new BufferedReader(isr);
				header = null;
				cb = new CircularBuffer(MAX_ARRAY_SIZE);
				String line = null;
				int i = 0;
				while ((line = br.readLine()) != null)
				{
					i++;
					if (type.equals("OUTPUT"))
					{
						if (line.startsWith("!"))
						{
							if (header == null)
								header = new String();
							header += line + "\n";
						}
						else
						{
							synchronized (cb)
							{
								cb.put(line);
							}
						}

						/*
						 * //we don't want to take more than .5Gigs, so assume an entrie is 6 chars, = 12 bytes, ->
						 * about 44.7M entries in .5 Gb if((numColumns * size) < 44700000) { sb.append(line + "\n");
						 * if(!line.startsWith("!")) size++; } else maxedOut = true;
						 */
					}
					else // equals error
					{
						synchronized (cb)
						{
							cb.put(line);
						}
						System.out.println("read stream, type="+type+" -- "+i + " runDaq: " + line);
					}
				}
			}
			catch (IOException ioe)
			{
				ioe.printStackTrace();
			}
		}
		

		public CircularBuffer getResults()
		{
			return cb;
		}


		public String getHeader()
		{
			return header;
		}

		private String header;
		private CircularBuffer cb;
	} //----------------------end of StreamGobber class

	
	
	
	
	/**
	 * This class run the runDaq command and collect the NSRL data
	 * 
	 *
	 */
	private class DaqRunner extends Thread
	{

		public DaqRunner(String file, int columnSizeIn)
		{
			_fileName = file;
			_columnSize = columnSizeIn;
		}

		@Override
		public void run()
		{
			try
			{
				String[] command = { "runDaq", "-date", _fileName };
				String[] envp = { LD_PATH };
				System.out.println("File Name for runDaq: " + _fileName);

				_userEnded = false;
				_nowAcquiring = true;
				_daqProcess = Runtime.getRuntime().exec(command, envp, new File("/ride/release/X86/bin/"));

				// any output?
				_outputGobbler = new StreamGobbler(_daqProcess.getInputStream(), "OUTPUT");
				StreamGobbler errorGobler = new StreamGobbler(_daqProcess.getErrorStream(), "ERROR");
				
				_outputGobbler.start();
				errorGobler.start();
				
				//wait for the data acquisition process to finish
				int retval = _daqProcess.waitFor();

				// data acquisition process finished
				_nowAcquiring = false;
// 				if (_analyze != null)
// 					_analyze.nowAcquiring(false);

				// write end time to file
				if (outputFile != null)
				{
					if ((new File(outputFile)).exists())
					{
						FileWriter writer = new FileWriter(outputFile, true);
						PrintWriter out = new PrintWriter(writer);
						out.println("#" + dateFormat.format(new Date()));
						if(_headerInfo.getComments()!=null) out.println("#" + _headerInfo.getComments());
						out.flush();
						out.close();
						writer.close();
					}
				}

				// alert the thread which is flashing acquire that this is done
				_run = false;

				/*
				 * if(_userEnded) //set to false if user cancels data acq. so we don't get io errors { if
				 * (_daqProcess.getErrorStream() != null) {
				 * 
				 * BufferedReader br = new BufferedReader(new InputStreamReader(_daqProcess.getErrorStream()));
				 * 
				 * String line = br.readLine(); while (line != null) { System.out.println(line); line = br.readLine(); }
				 * } }
				 */

				if (!_userEnded) // if user cancels, END_CAPTURE_COMMAND was already run, and do we want the error
									// message? (Always has error code 143).
				{
					if (retval == 0)
					{
						endCapture();
					}
					else
					{
						EventDispatcher.getInstance().fireEvent(new ActionEvent(_endCapture, 1,	END_CAPTURE_COMMAND));
						JOptionPane.showMessageDialog(MainFrame.this,"Data Acquisition Process has ended with error code: "
										+ retval + ".", "Process Failed",JOptionPane.ERROR_MESSAGE);
					}
				}
				_daqProcess = null;
			}
			catch (java.lang.InterruptedException ie)
			{
				ie.printStackTrace();
			}
			catch (IOException ioe)
			{
				ioe.printStackTrace();
			}
		}

		protected String _fileName;
		protected int _columnSize;
	}

	
	
	
	/**
	 * Error checking method to determine if the user can start capturing data.
	 * 
	 * @return boolean if the user can capture data.
	 */
	private boolean canCapture()
	{
		String message = "The following must be specified before capture:\n";
		boolean fieldSel = true;
		boolean chanSel = false;
		boolean modSel = false;
		boolean incSel = false;

		if (_dirty)
		{
			JOptionPane
					.showMessageDialog(
							this,
							message,
							"You must save changes to this configuration before running.",
							JOptionPane.ERROR_MESSAGE);
			return false;
		}

		if (_headerInfo.getIonSpecies().equals("")
				|| _headerInfo.getIonSpecies() == null)
		{
			message += "\t  Ion Species\n";
			fieldSel = false;
		}
		if (_headerInfo.getEnergy().equals("")
				|| _headerInfo.getEnergy() == null)
		{
			message += "\t  Energy\n";
			fieldSel = false;
		}
		if (_headerInfo.getNumEvents().equals("")
				|| _headerInfo.getNumEvents() == null)
		{
			message += "\t  Number of Events\n";
			fieldSel = false;
		}

		Enumeration<ModulePane> panels = _panels.elements();

		while (panels.hasMoreElements())
		{
			ModulePane module = panels.nextElement();
			boolean[] channels = module.getChannels();

			for (int j = 0; j < channels.length; j++)
			{
				if (channels[j])
				{
					chanSel = true;
					break;
				}
			}

			if (module.isTrigger())
			{
				modSel = true;
			}

			if (module.isIncrementer())
			{
				incSel = true;
			}

		}

		if (!chanSel)
		{
			message += "\t  At least 1 channel\n";
		}

		if (!modSel)
		{
			message += "\t  A trigger module\n";
		}

		if (!incSel)
		{
			message += "\t  An incrementer module\n";
		}

		if (!(chanSel && modSel && incSel && fieldSel))
		{
			JOptionPane.showMessageDialog(this, message,
					"Empty Required Fields", JOptionPane.ERROR_MESSAGE);
		}

		return (chanSel && modSel && incSel && fieldSel);
	}

	private int getActiveChannels()
	{
		int activeChannels = 0;
		Enumeration<ModulePane> panes = _panels.elements();
		while (panes.hasMoreElements())
		{
			boolean[] channels = panes.nextElement().getChannels();
			for (int i = 0; i < channels.length; i++)
			{
				if (channels[i])
				{
					activeChannels++;
				}
			}
		}

		return activeChannels;
	}

	
	
	
	/**
	 * listen for window closings
	 */
	private class MainWindowAdapter extends WindowAdapter
	{

		public void windowClosing(WindowEvent event)
		{
			if (_dirty)
			{
				int response = JOptionPane
						.showConfirmDialog(
								MainFrame.this,
								"Do you wish to save the current configuration before exiting?",
								"Unsaved Configuration Changes",
								JOptionPane.YES_NO_CANCEL_OPTION,
								JOptionPane.WARNING_MESSAGE);

				if (response == JOptionPane.NO_OPTION)
				{
					exit(false);
				}
				else if (response == JOptionPane.YES_OPTION)
				{
					/* Fire a save operation then quit */
					ActionEvent e = new ActionEvent(_saveItem,
							ActionEvent.ACTION_PERFORMED, SAVE_CONFIG_COMMAND);
					EventDispatcher.getInstance().actionPerformed(e);

					exit(false);
				}
			}
			else
			{
				exit(true);
			}
		}
	}

	
	
	/**
	 * Adds a message to the message area.
	 * 
	 * @param message
	 *            the message to add.
	 */
	public static void addMessage(String message)
	{
		_messageArea.append(message);
	}
    
	/**
	 * GeneralActionListener -- listener class for the MainFrame events.
	 */
	private class GeneralActionListener implements ActionListener
	{
            public GeneralActionListener() {
                DEFAULT_DIR = this.DEFAULT_DIR;
            }

		private String DEFAULT_DIR = null;

		public void actionPerformed(ActionEvent e)
		{

			/* exit the app */
			if (e.getActionCommand().equals(APPLICATION_QUIT_COMMAND))
			{

				exit(false);
			}
			else if (e.getActionCommand().equals(ANALYZE))
			{
// 				if (_analyze == null)
// 				{
// 					_analyze = new Analyze(MainFrame.this);
// 				}
// 				else
// 				{
// 					if (!_analyze.isVisible())
// 						_analyze.setVisible(true);
// 					_analyze.toFront();
// 				}
			}
			/* open a new configuration file */
			else if (e.getActionCommand().equals(OPEN_CONFIG_COMMAND))
			{

				if (_dirty)
				{
					int response = JOptionPane
							.showConfirmDialog(
									MainFrame.this,
									"There are unsaved changes to this config.\n"
											+ "Do you wish to save the current configuration?",
									"Unsaved Configuration Changes",
									JOptionPane.YES_NO_CANCEL_OPTION,
									JOptionPane.WARNING_MESSAGE);

					if (response == JOptionPane.NO_OPTION)
					{
						clear(false); /* Clear the dirty state */
						this.actionPerformed(e); /* refire the event */
					}
					else if (response == JOptionPane.YES_OPTION)
					{
						ActionEvent event = new ActionEvent(_saveItem,
								ActionEvent.ACTION_PERFORMED,
								SAVE_CONFIG_COMMAND);
						this.actionPerformed(event);
					}
				}
				else
				{
					String dir = DEFAULT_DIR + "config/";
					if (Main.MODE == Constants.ZDC)
						dir += "zdc/";
					else if (Main.MODE == Constants.NSRL)
						dir += "nsrl/";
					JFileChooser chooser = new JFileChooser(dir);
					chooser.setDialogTitle("Open... NSRL DAQ Configuration");

					int returnVal = chooser.showOpenDialog(MainFrame.this);
					if (returnVal == JFileChooser.APPROVE_OPTION)
					{
						try
						{
							// we need to clear all the current panels
							_headerInfo.clear();
							clear(true);

							_headerInfo.setAllPaneData(XmlUtils.getInstance()
									.loadXMLIntoHeader(
											chooser.getSelectedFile()
													.getAbsolutePath()));

							XmlUtils.getInstance()
									.loadXMLIntoModules(
											chooser.getSelectedFile()
													.getAbsolutePath(), _panels);

							addMessage(chooser.getSelectedFile()
									.getAbsolutePath()
									+ " loaded successfully.");

						}
						catch (org.jdom.JDOMException jde)
						{
							addMessage("There was an error loading the configuration file: "
									+ chooser.getSelectedFile()
											.getAbsolutePath());
							System.out.println(jde.getMessage());
						}
						catch (java.io.IOException ioe)
						{
							addMessage("Error, "
									+ chooser.getSelectedFile()
											.getAbsolutePath()
									+ " could not be found.");
							System.out.println(ioe.getMessage());
						}
					}
					chooser = null;
				}

			}
			/* save the current configuration file */
			else if (e.getActionCommand().equals(SAVE_CONFIG_COMMAND)
					|| e.getActionCommand().equals(SAVE_AS_CONFIG_COMMAND))
			{

				/*
				 * Check to see if this config has already been saved Only check if this is a save command for file name
				 */
				if ((!_headerInfo.getFileName().equals(""))
						&& (e.getActionCommand().equals(SAVE_CONFIG_COMMAND)))
				{
					try
					{
						boolean val = XmlUtils.getInstance().saveXml(
								new File(_headerInfo.getFileName()), _panels,
								_headerInfo.getAllPaneData());

						addMessage(_headerInfo.getFileName()
								+ " saved successfully.");

						/* Reset the state of the _dirty flag */
						clear(false);
					}
					catch (Exception ex)
					{
						addMessage("Error, the current configuration could not be saved."
								+ "Please try a new file name.");
						System.out.println(ex.getMessage());
					}
				}
				else
				{
					String dir = DEFAULT_DIR + "config/";
					if (Main.MODE == Constants.ZDC)
						dir += "zdc/";
					else if (Main.MODE == Constants.NSRL)
						dir += "nsrl/";
					JFileChooser chooser = new JFileChooser(dir);
					chooser.setDialogTitle("Save As... NSRL DAQ Configuration");

					int returnVal = chooser.showSaveDialog(MainFrame.this);
					if (returnVal == JFileChooser.APPROVE_OPTION)
					{
						String fileName = chooser.getSelectedFile()
								.getAbsolutePath();

						/* Ask for file overwrite */
						File file = new File(fileName);
						if (file.exists())
						{
							int response = JOptionPane
									.showConfirmDialog(
											MainFrame.this,
											"The File Name you entered already exists.\n"
													+ "Do you wish to overwrite the existing file?",
											"nsrlDataAcquisition",
											JOptionPane.YES_NO_CANCEL_OPTION,
											JOptionPane.WARNING_MESSAGE);

							if (response == JOptionPane.YES_OPTION)
							{
								/* Then save as normal */
								try
								{
									boolean val = XmlUtils.getInstance()
											.saveXml(
													file,
													_panels,
													_headerInfo
															.getAllPaneData());

									_headerInfo.setFileName(fileName);

									addMessage(chooser.getSelectedFile()
											.getAbsolutePath()
											+ " saved successfully.");

									/* Reset the state of the _dirty flag */
									clear(false);
								}
								catch (Exception ex)
								{
									addMessage("Error, the current configuration could not be saved."
											+ "Please try a new file name.");
									System.out.println(ex.getMessage());
								}
							}
							else if (response == JOptionPane.NO_OPTION)
							{
								ActionEvent event = new ActionEvent(
										_saveAsItem,
										ActionEvent.ACTION_PERFORMED,
										SAVE_AS_CONFIG_COMMAND);
								EventDispatcher.getInstance().actionPerformed(
										event);
							}
						}
						else
						{
							try
							{
								boolean val = XmlUtils.getInstance().saveXml(
										file, _panels,
										_headerInfo.getAllPaneData());

								_headerInfo.setFileName(fileName);

								addMessage(chooser.getSelectedFile()
										.getAbsolutePath()
										+ " saved successfully.");

								/* Reset the state of the _dirty flag */
								clear(false);
							}
							catch (Exception ex)
							{
								addMessage("Error, the current configuration could not be saved."
										+ "Please try a new file name.");
								System.out.println(ex.getMessage());
							}
						}
					}

					chooser = null;
				}
			}
			/* start the data capture process */
			else if (e.getActionCommand().equals(START_CAPTURE_COMMAND))
			{
				/************************************************************
				 * Run's Larry's program -MPM
				 ************************************************************/
				if (canCapture())
				{
					_startCapture.setEnabled(false);
					_endCapture.setEnabled(true);
					_dataConsole.setEnabled(true);

					XmlUtils.getInstance().saveRunXml(_panels,
							_headerInfo.getAllPaneData());

					int channels = getActiveChannels();

					try
					{
						outputFile = XmlUtils.getInstance()
								.getConfigOuputFile();

						// write and flush header block with comments and time stamp to file (lines start with #
						FileWriter writer = new FileWriter(outputFile, true);
						PrintWriter out = new PrintWriter(writer);
						out.println("#" + dateFormat.format(new Date()));
						if (_headerInfo.getComments() != null)
							out.println("#" + _headerInfo.getComments());
						out.flush();
						out.close();
						writer.close();

						DaqRunner runner = new DaqRunner(
								XmlUtils.DEFAULT_RUN_CONFIG, XmlUtils
										.getInstance().getRunColumnNames()
										.size());
						runner.start();

						// notify necessary popups
						if (_data != null)
							_data.newAcquisition(XmlUtils.getInstance()
									.getConfigOuputFile(), XmlUtils
									.getInstance().getRunColumnNames());
// 						if (_analyze != null)
// 							_analyze.nowAcquiring(true);

						// boolean used for the loop of the flashing status thread
						_run = true;
						Thread statusFlash = new Thread()
						{
							public void run()
							{
								while (_run)
								{
									try
									{
										Runnable flash = new Runnable()
										{
											public void run()
											{
												if (_runningStatus.isVisible())
												{
													_runningStatus
															.setVisible(false);
												}
												else
												{
													_runningStatus
															.setForeground(Color.GREEN);
													_runningStatus
															.setVisible(true);
												}
											}
										};
										SwingUtilities.invokeLater(flash);
										sleep(1000);
									}
									catch (Exception ex)
									{
									}
								}
								_runningStatus.setVisible(false);
							}
						};

						statusFlash.start();

						addMessage("Data capture started for: "
								+ _headerInfo.getConfigName()
								+ ", Data File: "
								+ outputFile.substring(outputFile
										.lastIndexOf('/') + 1));
					}
					catch (Exception exp)
					{
						exp.printStackTrace();
					}
					addMessage("Data capture started for " + channels
							+ " channels.");
				}
			}
			/* end the data capture process */
			else if (e.getActionCommand().equals(END_CAPTURE_COMMAND))
			{
				_startCapture.setEnabled(true);
				_endCapture.setEnabled(false);
				_dataConsole.setEnabled(false);

				_userEnded = true;
				_daqProcess.destroy();
				XmlUtils.getInstance().deleteRunConfig();
				addMessage("Data capture ended for "
						+ _headerInfo.getConfigName());
			}
			/* start a data console for the currently running data capture */
			else if (e.getActionCommand().equals(START_DATA_CONSOLE_COMMAND))
			{
				// System.out.println("Start Data Console Button Pushed");
				try
				{
					String outputFile = XmlUtils.getInstance()
							.getConfigOuputFile();
					if (outputFile == null || outputFile == "")
					{
						addMessage("No data file could be found.");
					}
					else
					{
						addMessage("Data file found: "
								+ outputFile.substring(outputFile
										.lastIndexOf('/') + 1));
						addMessage("Starting Data Window...");
						if (_data == null)
						{
							_data = new DataConsoleThreaded(MainFrame.this,
									outputFile, XmlUtils.getInstance()
											.getRunColumnNames());
						}
						else
						{
							if (!_data.isVisible())
								_data.setVisible(true);
							_data.toFront();
						}
					}
				}
				catch (Exception exp)
				{
					exp.printStackTrace();
				}

			} 
			/* create a new, empty configuration */
			else if (e.getActionCommand().equals(NEW_CONFIG_COMMAND))
			{
				if ((_dirty))
				{
					int response = JOptionPane
							.showConfirmDialog(
									MainFrame.this,
									"There are unsaved changes to this config.\n"
											+ "Do you wish to save the current configuration?",
									"Unsaved Configuration Changes",
									JOptionPane.YES_NO_CANCEL_OPTION,
									JOptionPane.WARNING_MESSAGE);

					if (response == JOptionPane.NO_OPTION)
					{
						_headerInfo.clear();
						clear(true);
						addMessage("Created new configuration.");
					}
					else if (response == JOptionPane.YES_OPTION)
					{
						ActionEvent event = new ActionEvent(_saveItem,
								ActionEvent.ACTION_PERFORMED,
								SAVE_CONFIG_COMMAND);
						EventDispatcher.getInstance().actionPerformed(event);

						_headerInfo.clear();
						clear(true);
						addMessage("Created new configuration.");
					}

				}
				else
				{
					_headerInfo.clear();
					clear(true);
					addMessage("Created new configuration.");
				}
			} 
			/*
			 * Bubble event handlers, there events are fired from the ModulePane and the ConfigurationPanes, these
			 * events bubble up to here.
			 */
			else if (e.getActionCommand().equals(
					ConfigurationPane.KEY_TYPED_COMMAND)
					|| e.getActionCommand().equals(
							ModulePane.CHANNEL_BUTTON_CLICK))
			{

				/* Maintain the dirty state of this configuration */
				if (!_dirty)
				{
					_dirty = true;
					_saveConfig.setEnabled(true);
					_saveItem.setEnabled(true);
					_saveConfig.setEnabled(true);
					_startCapture.setEnabled(false);
				}
			}
		}
	}
    
	/**
     * 
     */
	private class FileMenuListener implements MenuListener
	{

		public void menuCanceled(MenuEvent e)
		{
		}

		public void menuDeselected(MenuEvent e)
		{
		}

		public void menuSelected(MenuEvent e)
		{
			if (_dirty)
			{
				_saveItem.setEnabled(true);
				_saveConfig.setEnabled(true);
			}
			else
			{
				_saveItem.setEnabled(false);
				_saveConfig.setEnabled(false);
			}
		}
	}

	
	public int getCurrentDataRequestSize()
	{
		try
		{
			return (nf.parse(_headerInfo.getNumEvents())).intValue();
		}
		catch (ParseException pe)
		{
			return -1;
		}
	}

	public boolean isAcquiring()
	{
		return _nowAcquiring;
	}
    
    public static final String OPEN_CONFIG_COMMAND = "OPEN_CONFIG";
    public static final String SAVE_CONFIG_COMMAND = "SAVE_CONFIG";
    public static final String START_CAPTURE_COMMAND = "START_CAPTURE";
    public static final String SAVE_AS_CONFIG_COMMAND = "SAVE_AS";
    public static final String END_CAPTURE_COMMAND = "END_CAPTURE";
    public static final String START_DATA_CONSOLE_COMMAND = "START_DATA";
    public static final String ANALYZE = "ANALYZE";
    public static final String OUTPUT_FILE_COMMAND = "SELECT_OUTPUT";
    public static final String NEW_CONFIG_COMMAND = "NEW_CONFIG";
    public static final String APPLICATION_QUIT_COMMAND = "APP_QUIT";
    public static final String FILE_MENU = "FILE_MENU";
    public static String DEFAULT_DATA_DIR = null;
    public static String DEFAULT_DIR = null;
    private static final String LD_PATH = "LD_LIBRARY_PATH=/lib:/usr/lib:/usr/local/lib:";
    public static final long serialVersionUID = 1L;
    private JMenuItem _newConfigItem;
    private JMenuItem _openItem;
    private JMenuItem _saveItem;
    private JMenuItem _saveAsItem;
    private JMenuItem _quitItem;
    private Vector<ModulePane> _panels;
    public static MessageArea _messageArea;
    private Dimension _screenSize;
    private ConfigurationPane _headerInfo;
    private boolean _dirty;
    private boolean _newconfig;
    private Process _daqProcess;
    private JPanel _moduleLayer;
    private JButton _saveConfig;
    private JButton _startCapture;
    private JButton _endCapture;
    private JButton _dataConsole;
    private JButton _analyzeButton;
    private JLabel _runningStatus;
    private boolean _run;
    private boolean DEFAULT_TO_LATEST_CONFIG = true;
    private NumberFormat nf = NumberFormat.getInstance(); 
    private DataConsoleThreaded _data;
//     private Analyze _analyze;
    private boolean _userEnded, _nowAcquiring;
    public static final int MAX_ARRAY_SIZE = 10000;
    public StreamGobbler _outputGobbler;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss MMM d yyyy");
    private String outputFile;    
 
}
