// package gov.bnl.cad.swing;

import java.awt.*;
import java.awt.event.*;
import java.util.Date;
import java.text.DateFormat;

import javax.swing.JTextArea;
import javax.swing.JPopupMenu;
import javax.swing.JMenuItem;

/**
* A message area that displays timeStamps with each message entered and
* provides the new line feed at the end of each message as well as a
* clear menu
*/
public class MessageArea extends JTextArea implements ActionListener {
   public MessageArea() {
      super();
      
      init(5);
   }
   
   public MessageArea(int nrows) {
      super();
      
      init(nrows);
   }
   
   private void init(int nrows) {
      
      super.setRows(nrows);
      super.setEditable(false);
      super.setLineWrap(true);
      super.addMouseListener(new MessageAreaMouseListener());
      _menu = new MessageAreaMenu(this);
   }
   
   public void append(String text) {
      super.append(DateFormat.getDateTimeInstance().format(new Date()));
      super.append(": ");
      super.append(text + "\n");
      super.setCaretPosition(getText().length());
   }
   
   public void actionPerformed(ActionEvent e) {
      if (e.getActionCommand().equals("ClearMessageArea")){
         super.setText("");
         _menu.setVisible(false);
      }
   }
   
   class MessageAreaMenu extends JPopupMenu
   {
      public MessageAreaMenu(MessageArea messageArea) {
         JMenuItem clear = new JMenuItem("Clear");
         clear.setActionCommand("ClearMessageArea");
         clear.addActionListener(messageArea);
         _messageMenu.add(clear);
      }
      
      public static final long serialVersionUID = 1L;
   }
   
   class MessageAreaMouseListener extends MouseAdapter {
      public void mousePressed(MouseEvent e) {
         maybeShowPopup(e);
      }
      
      public void mouseReleased(MouseEvent e) {
         maybeShowPopup(e);
      }
      
      private void maybeShowPopup(MouseEvent e) {
         if (e.isPopupTrigger())
            _messageMenu.show(e.getComponent(), e.getX(), e.getY());
      }
   }

   public static final long serialVersionUID = 1L;

   private MessageAreaMenu _menu = null;
   private JPopupMenu _messageMenu = new JPopupMenu();
}
