// package nsrlDataAcquisition;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
import javax.swing.JRadioButton;
import javax.swing.SwingConstants;

/**
 *
 * @author: initially created by pucci
 * 09/22/2011 Updated by Controls
 * 
 */
public class ModulePane extends JPanel {

    /**
     * Constructor for the new Module Panel
     * 
     * @param address 
     * @param addrSpace
     * @param dataWidth
     * @param dataSize
     * @param numChannels
     * @param type
     */
    public ModulePane(String name, String address, String addrSpace, String dataWidth,
            String dataSize, String[] channelNames, int numChannels, int type) {
        super();

        _address = address;
        _addrSpace = addrSpace;
        _dataWidth = dataWidth;
        _dataSize = dataSize;
        _moduleType = type;
        _name = name;

        //Create the ChannelPane which contains the channel buttons
        _channels = new ChannelsPane(numChannels, name, MAX_SIZE, channelNames);

        setMinimumSize(MAX_SIZE);
        setLayout(new GridLayout(0, 1));
        setBackground(new Color(109, 109, 109));
        setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        
        add(_channels);
    }

    public void clear() {
        this._channels.clear();
    }

    public void setChannelActive(int chan) {
        this._channels.setChannelActive(chan);
    }

    public String getAddrSpace() {
        return _addrSpace;
    }

    public void setAddrSpace(String _addrSpace) {
        this._addrSpace = _addrSpace;
    }

    public String getAddress() {
        return _address;
    }

    public void setAddress(String _address) {
        this._address = _address;
    }

    public String getDataSize() {
	//System.out.println("ModulePane.getDataSize() " + _name + " _dataSize " + _dataSize);
        return _dataSize;
    }

    public void setDataSize(String _dataSize) {
	//System.out.println("ModulePane.setDataSize() " + _name + " _dataSize " + _dataSize);
        this._dataSize = _dataSize;
    }

    public String getDataWidth() {
        return _dataWidth;
    }

    public void setDataWidth(String _dataWidth) {
        this._dataWidth = _dataWidth;
    }

    public int getModuleType() {
        return _moduleType;
    }

    public void setModuleType(int _moduleType) {
        this._moduleType = _moduleType;

        switch (this._moduleType) {
            case ModulePane.MODULE_TYPE_TRIG:
                this._channels.setTrigger(true);
                break;
            case ModulePane.MODULE_TYPE_INC:
                this._channels.setIncrementer(true);
                break;
        }
    }

    public String getName() {
        return _name;
    }

    public boolean isTrigger() {
        return this._channels.isTrigger();
    }
    
    public boolean isIncrementer(){
        return this._channels.isIncrementer();
    }

    public void setName(String _name) {
        this._name = _name;
        this._channels.setName(_name);
    }

    public boolean[] getChannels() {
        return this._channels.getChannels();
    }

    public String[] getChannelNames() {
        return this._channels.getNames();
    }

    //This set the name of a channel in a module    
    public void setChannelName(int _index, String _chname) {
        //return this._channels.getNames();
    	this._channels.setChannelName(_chname, _index);
    }  
    
    
    /**
     * ChannelsPane is the class which contains all the JRadioButtons for a
     * single module. It is an inner class of ModulePane since it is only used
     * on a ModulePane.
     * @Param:
     * numChannels: number of channels
     * name:
     * channelNames: channel names.
     */
    private class ChannelsPane extends JPanel {

        public ChannelsPane(int numChannels, String name, Dimension defaultDim, String[] channelNames) {
            _numChannels = numChannels;
            _channelsArray = new boolean[_numChannels];
            _channelNames = new String[_numChannels];

           _channelLbs=new JLabel[_numChannels];
           _channelBtns=new JRadioButton[_numChannels];             
            
            
            for (int i = 0; i < channelNames.length; i++) {
                _channelNames[i] = channelNames[i];
            }

            _name = name;

            setMinimumSize(defaultDim);
            setMaximumSize(defaultDim);
            //setLayout(new BoxLayout(this, BoxLayout.Y_AXIS)); //can't control resize weight with a BoxLayout
	    setLayout(new GridBagLayout());
            setBackground(Color.WHITE);
            GridBagConstraints c = new GridBagConstraints();

            //Add this ActionListener to the EventDispatcher
            EventDispatcher.getInstance().addActionListener(new ChannelButtonListener(_name));

            //Add our _headerPanel
            _headerPanel = new JPanel();
            _headerPanel.setFont(new Font("Sans", Font.BOLD, 16));
            _headerPanel.setBackground(Color.blue.brighter());
            _headerPanel.setForeground(Color.white);
            _headerPanel.setLayout(new FlowLayout());
            _headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK),
                    BorderFactory.createEmptyBorder(5, 5, 5, 5)));



            JLabel lab = new JLabel(_name);
            lab.setFont(new Font("Sans", Font.BOLD, 16));
            lab.setForeground(Color.white);
            lab.setBackground(Color.blue.brighter());
            lab.setHorizontalTextPosition(SwingConstants.CENTER);
            _headerPanel.add(lab);


            c.gridx = 0;
            c.gridy = 0;
            c.weighty = 0;
            c.weightx = 1;
            //c.gridwidth = 4;
	    c.gridwidth = 1;
	    c.anchor = GridBagConstraints.CENTER;
            //c.anchor = GridBagConstraints.FIRST_LINE_START;
            c.fill = GridBagConstraints.BOTH;
            add(_headerPanel, c);

            //If our channel buttons can all fit in one column
            _channelsHolder = new JPanel();
            _channelsHolder.setBackground(Color.white);
            _channelsHolder.setLayout(new GridBagLayout());
	    _channelsHolder.setPreferredSize(new Dimension(112, 302));
	    _channelsHolder.setMaximumSize(new Dimension(112, 302));
            int switchRow = 0;
            int gridxReset = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weighty = 1;
            c.weightx = 0.1;
            c.anchor = GridBagConstraints.CENTER;
            c.fill = GridBagConstraints.HORIZONTAL;

            for (int i = 0; i < _numChannels; i++) {
                //JRadio
                //JLabel chanLabel = new JLabel(String.valueOf(i));                
            	_channelLbs[i]= new JLabel(String.valueOf(i));  
                //chanLabel.setForeground(Color.black);
                //chanLabel.setToolTipText("channel: " + String.valueOf(i));                
            	_channelLbs[i].setForeground(Color.black);
                _channelLbs[i].setToolTipText(_channelNames[i]);  	
            	c.insets = new Insets(0, 7, 0, 0);
                //_channelsHolder.add(chanLabel, c);
            	_channelsHolder.add(_channelLbs[i], c);
            	c.gridx++;
                
                

                c.insets = new Insets(0, 0, 0, 0);
                _channelBtns[i]=this.createChannelButton(i);
                //_channelsHolder.add(this.createChannelButton(i), c);
                _channelsHolder.add(_channelBtns[i], c);
                c.gridy++;

                c.gridx = gridxReset;
                switchRow++;
                if (switchRow == 8) {
                    gridxReset += 2;
                    c.gridx = gridxReset;
                    c.gridy = 0;
                    switchRow = 0;
                }

            }

	    c.gridy = 1;
	    c.gridx = 0;
	    c.weightx = 1;
	    c.weighty = 1;
	    c.fill = GridBagConstraints.BOTH;
	    add(_channelsHolder, c);

            c.gridy = 2;
            c.gridx = 0;
	    c.weighty = 0;
            //c.gridwidth = 4;
            //c.fill = GridBagConstraints.HORIZONTAL;
            c.anchor = GridBagConstraints.CENTER;

	    if(_moduleType == ModulePane.MODULE_TYPE_TRIG)
	    {
		JPanel trigPanel = new JPanel();
		trigPanel.setPreferredSize(new Dimension(MAX_SIZE.width, 35));
		trigPanel.setMinimumSize(trigPanel.getPreferredSize());
		trigPanel.setBackground(getBackground());
		trigPanel.setLayout(new FlowLayout());
		trigPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
		_trigger = new JRadioButton("Trigger");
		_trigger.setName("Trigger");
		_trigger.setBackground(this.getBackground());
		_trigger.setIcon(new UnselectedChannelIcon(12, 12));
		_trigger.setSelectedIcon(new SelectedChannelIcon(12, 12));
		_trigger.setSelected(false);
		_trigger.addActionListener(EventDispatcher.getInstance());
		_trigger.setActionCommand(this._name + _address + "^" + "trigger");
		trigPanel.add(_trigger);
		setTrigger(true);
		//_trigger.setEnabled(false); //user can't change //update - Ben has this in the listener, any click of this button will cause it to be selected, so no worries
		//System.out.println("trigger selected: " + _trigger.isSelected());
		
		//_channelsHolder.add(trigPanel, c);
		add(trigPanel, c);
	    }
            
            //c.gridy++;
	    else if(_moduleType == ModulePane.MODULE_TYPE_INC)
            {
		JPanel incPanel = new JPanel();
		incPanel.setPreferredSize(new Dimension(MAX_SIZE.width, 35));
		incPanel.setMinimumSize(incPanel.getPreferredSize());
		incPanel.setBackground(getBackground());
		incPanel.setLayout(new FlowLayout());
		incPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
		_incrementer = new JRadioButton("Incrementer");
		_incrementer.setName("Incrementer");
		_incrementer.setBackground(this.getBackground());
		_incrementer.setIcon(new UnselectedChannelIcon(12, 12));
		_incrementer.setSelectedIcon(new SelectedChannelIcon(12, 12));
		_incrementer.setSelected(false);
		_incrementer.addActionListener(EventDispatcher.getInstance());
		_incrementer.setActionCommand(this._name + _address + "^" + "incrementer");
		incPanel.add(_incrementer);
		setIncrementer(true);
		//_incrementer.setEnabled(false); //user can't change //update - Ben has this in the listener, any click of this button will cause it to be selected, so no worries
		
		//_channelsHolder.add(incPanel, c);
		add(incPanel, c);
	    }
	    else
	    {
		JPanel blankPanel = new JPanel();
		blankPanel.setPreferredSize(new Dimension(MAX_SIZE.width, 35));
		blankPanel.setMinimumSize(blankPanel.getPreferredSize());
		blankPanel.setBackground(getBackground());
		blankPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));

		//_channelsHolder.add(blankPanel, c);
		add(blankPanel, c);
	    }
	    //add(_channelsHolder);	

            setBorder(BorderFactory.createLineBorder(Color.BLACK, 3));
        }

        private boolean[] getChannels() {
            return this._channelsArray;
        }

        private String[] getNames() {
            return this._channelNames;
        }

        private void setChannels(boolean[] _channels) {
            this._channelsArray = _channels;
        }

        private int getNumChannels() {
            return _numChannels;
        }

        private void setNumChannels(int _numChannels) {
            this._numChannels = _numChannels;
        }

        public String getName() {
            return _name;
        }

        public void setName(String _name) {
            this._name = _name;
        }

        //_channelNames---added 09/21/2011
        public void setChannelName(String _name, int _index) {
        	 System.out.println("Set channel "+_index+":  "+_name);
            _channelNames[_index]=_name;
            _channelLbs[_index].setToolTipText(_name);
            _channelBtns[_index].setToolTipText(_name);   
        }
        
        
        private void setChannelActive(int chan) {
            if (chan < _channelsArray.length) {
                this._channelsArray[chan] = true;

                Component[] chanButtons = this._channelsHolder.getComponents();
                for (int i = 0; i < chanButtons.length; i++) {
                    if (chanButtons[i] instanceof JRadioButton) {
                        if (chanButtons[i].getName().equals("Channel " + chan)) {
                            ((JRadioButton) chanButtons[i]).setSelected(true);
                            break;
                        }
                    }
                }

                this.repaint();
            }
        }

		private void clear()
		{

			// setTrigger(false);
			// setIncrementer(false);

			for (int i = 0; i < _channelsArray.length; i++)
			{
				this._channelsArray[i] = false;
			}

			Component[] chanButtons = this._channelsHolder.getComponents();
			for (int i = 0; i < chanButtons.length; i++)
			{
				if (chanButtons[i] instanceof JRadioButton)
				{
					((JRadioButton) chanButtons[i]).setSelected(false);
				}
			}

			if (_moduleType == ModulePane.MODULE_TYPE_TRIG) // select channel 15
			{
				setTrigger(true);
				this._channelsArray[this._channelsArray.length - 1] = true;
				((JRadioButton) chanButtons[chanButtons.length - 1])
						.setSelected(true);
			}
			if (_moduleType == ModulePane.MODULE_TYPE_INC) // select channel 15
			{
				setIncrementer(true);
				this._channelsArray[this._channelsArray.length - 1] = true;
				((JRadioButton) chanButtons[chanButtons.length - 1])
						.setSelected(true);
			}

			this.repaint();
		}

        private JRadioButton createChannelButton(int channel) {
            JRadioButton button = new JRadioButton();
            button.setName("Channel " + channel);
            button.setBackground(this.getBackground());
            button.setIcon(new UnselectedChannelIcon());
            button.setSelectedIcon(new SelectedChannelIcon());

            //added 09/21/2011
            button.setToolTipText(_channelNames[channel]);

			// if module is trigger or incrementer, we always want channel 15 selected **Also see code in
			// actionPerformed() below
			if ((channel == 15)
					&& ((_moduleType == ModulePane.MODULE_TYPE_TRIG) || (_moduleType == ModulePane.MODULE_TYPE_INC)))
				button.setSelected(true);
			else
				button.setSelected(false);
						
            button.addActionListener(EventDispatcher.getInstance());
            button.setActionCommand(this._name + _address + "^" + String.valueOf(channel));
    
            button.addMouseListener(new MouseListener() 
            {
            	public  void mouseClicked(MouseEvent e)
            	{
            	     if(e.getButton()==MouseEvent.BUTTON3 && ((JRadioButton)e.getSource()).isSelected())	
            	     {
            	    	 for(int i=0; i<_numChannels; i++)
            	    	 {
                            if(e.getSource()==_channelBtns[i])
                            {
                            	updateChannelName(i);
                            }
                         }
            	     }
            	}

				@Override
				public void mouseEntered(MouseEvent arg0)
				{
					// TODO Auto-generated method stub
					
				}

				@Override
				public void mouseExited(MouseEvent arg0)
				{
					// TODO Auto-generated method stub
					
				}

				@Override
				public void mousePressed(MouseEvent arg0)
				{
					// TODO Auto-generated method stub
					
				}

				@Override
				public void mouseReleased(MouseEvent arg0)
				{
					// TODO Auto-generated method stub
					
				}
            });
            
            
            return button;
        }

        //change change name, added 09/21/2011--Wenge
        private void updateChannelName(int i)
        {
        	String tmp=_channelNames[i];   
        	
        	//trim off "Channel ??" part as they are reserved part
        	//int strlen=tmp.length();
        	//if(strlen<10) tmp="";
        	//else tmp=tmp.substring(10).trim();
        	
            String newname;
            //if(tmp.length()>0)
	            newname = JOptionPane.showInputDialog(this,
	                    "Current Channel Name: "+ tmp+"\n\nChange this name to :\n(The name you entered will be prefixed with 'Channel "+ String.valueOf(i)+"' automatically. \nSo please add only the part after 'Channel "+ String.valueOf(i)+"')",
	                    "Change Channel Name", //dialog title
	                    JOptionPane.OK_CANCEL_OPTION);

            if (newname != null &&  !newname.trim().equals("") && !newname.equals(tmp))
            {            	
            	System.out.println("Change channel ("+i+") name from "+ tmp + " to "+newname);     
            	setChannelName("Channel "+String.valueOf(i)+" "+newname, i) ;

            	//dirty data
            	EventDispatcher.getInstance().fireEvent(new ActionEvent(_channelBtns[i], ActionEvent.ACTION_PERFORMED, CHANNEL_BUTTON_CLICK));	
            }   	        
        }
        

        
        
        private boolean isTrigger() {
	    if(_trigger==null) return false;
	    else
		return this._trigger.isSelected();
        }

        private boolean isIncrementer() {
	    if(_incrementer==null) return false;
	    else
		return this._incrementer.isSelected();
        }
        
        /**
         * Set the trigger radio button along with its visual style
         * @param selected
         */
        private void setTrigger(boolean selected) {
	    if (this._trigger == null) return; //we took away the ability for all modules to be the trigger 9/2/08 -MPM
            if (selected) {
                _headerPanel.setForeground(Color.BLACK);
                _headerPanel.setBackground(Color.YELLOW);
                ((JLabel) _headerPanel.getComponent(0)).setForeground(Color.BLACK);
                ModulePane.this._moduleType = (ModulePane.MODULE_TYPE_TRIG);
            } else {
                _headerPanel.setBackground(Color.blue.brighter());
                _headerPanel.setForeground(Color.white);
                ((JLabel) _headerPanel.getComponent(0)).setForeground(Color.white);
                ModulePane.this._moduleType = (ModulePane.MODULE_TYPE_DATA);
            }
            
            this._trigger.setSelected(selected);
        }
        
        /**
         * Set the incrementer radion button along with its visual style
         * @param selected
         */
        private void setIncrementer(boolean selected){
	    if (this._incrementer == null) return; //we took away the ability for all modules to be the incrementer 9/2/08 -MPM
            if (selected) {
                _headerPanel.setForeground(Color.white);
                _headerPanel.setBackground(Color.RED);
                ((JLabel) _headerPanel.getComponent(0)).setForeground(Color.white);
                ModulePane.this._moduleType = (ModulePane.MODULE_TYPE_INC);
            } else {
                _headerPanel.setBackground(Color.blue.brighter());
                _headerPanel.setForeground(Color.white);
                ((JLabel) _headerPanel.getComponent(0)).setForeground(Color.white);
                ModulePane.this._moduleType = (ModulePane.MODULE_TYPE_DATA);
            }
            
            this._incrementer.setSelected(selected);
        }
        
        public static final long serialVersionUID = 1L;
        
        private final Dimension MAX_SIZE = new Dimension(108, 383);
        private boolean _channelsArray[];
        public String _channelNames[];
        private JRadioButton _trigger;
        private JRadioButton _incrementer;
        private int _numChannels;
        private Dimension _default;
        private JPanel _headerPanel;
        private JPanel _channelsHolder;
        private String _name;
        private boolean _dirty;
        private JLabel _channelLbs[];
        private JRadioButton _channelBtns[];        
    }

    private class SelectedChannelIcon implements Icon {

        private int width;
        private int height;

        public SelectedChannelIcon(int w, int h) {
            width = w;
            height = h;
        }

        public SelectedChannelIcon() {
            width = 24;
            height = 24;
        }

        public int getIconHeight() {
            return height;
        }

        public int getIconWidth() {
            return width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D) g.create();

            /*g2d.setColor(Color.white);
            g2d.fillRect(x + 1, y + 1, width - 2, height - 2);

            g2d.setColor(Color.white);
            g2d.drawRect(x + 1, y + 1, width - 2, height - 2);*/
            g2d.setBackground(_channels.getBackground());

            g2d.setColor(Color.BLACK);
            g2d.drawOval(x, y, width, height);
            g2d.fillOval(x, y, width, height);

            g2d.setColor(Color.gray.darker());
            g2d.drawOval(x + 1, y + 1, width - 2, height - 2);
            g2d.fillOval(x + 1, y + 1, width - 2, height - 2);

            g2d.setColor(Color.green.darker());
            g2d.drawOval(x + 2, y + 2, width - 4, height - 4);
            g2d.fillOval(x + 2, y + 2, width - 4, height - 4);

            g2d.setColor(Color.green.brighter());
            g2d.drawOval(x + 4, y + 4, width - 8, height - 8);
            g2d.fillOval(x + 4, y + 4, width - 8, height - 8);

            g2d.dispose();
        }
        }

    private class UnselectedChannelIcon implements Icon {

        private int width;
        private int height;

        public UnselectedChannelIcon(int w, int h) {
            width = w;
            height = h;
        }

        public UnselectedChannelIcon() {
            width = 24;
            height = 24;
        }

        public int getIconHeight() {
            return height;
        }

        public int getIconWidth() {
            return width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D) g.create();

            g2d.setBackground(_channels.getBackground());

            g2d.setColor(Color.BLACK);
            g2d.drawOval(x, y, width, height);
            g2d.fillOval(x, y, width, height);

            g2d.setColor(Color.gray.brighter());
            g2d.drawOval(x + 1, y + 1, width - 2, height - 2);
            g2d.fillOval(x + 1, y + 1, width - 2, height - 2);

            g2d.setColor(Color.gray.brighter());
            g2d.drawOval(x + 2, y + 2, width - 4, height - 4);
            g2d.fillOval(x + 2, y + 2, width - 4, height - 4);

            g2d.dispose();
        }
        }

    /**
     * Since we are using the EventDispatcher it will inform each Listener
     * everytime an event is fired, so this would fire for every single panel.
     * Therefor each radio _trigger action command has the name of the module
     * attached and some string processing is used to determine if this is the 
     * right panel to change the boolean array values.
     * This is just a little inefficient, but I will not change it right now -MPM 9/2/08
     */
    private class ChannelButtonListener implements ActionListener {

        private String _moduleName;

        public ChannelButtonListener(String moduleName) {
            this._moduleName = moduleName;
        }

	//when first written, the incrementer and trigger were not set automatically from nsrlDataAcquistion.conf
	//neither were channels 15 automatically selected
	//now they are, so we ignore button presses on these, (no dirtying)
	//but, if someone loads an old config file from config directory, and clicks one of these buttons, we need to dirty
	//this adds some complication below.
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JRadioButton) {
                try {
                    /* check if we are the new trigger module */
                    if (e.getActionCommand().contains("trigger")) {
                        if (e.getActionCommand().contains(_moduleName) && e.getActionCommand().contains(String.valueOf(_address))) //guaranteed that _trigger exists
			{
			    if(_channels._trigger.isSelected()) //going from unselected to selected state, need to dirty
				EventDispatcher.getInstance().fireEvent(new ActionEvent(e.getSource(), ActionEvent.ACTION_PERFORMED, CHANNEL_BUTTON_CLICK));
                            _channels.setTrigger(true);
                            //MainFrame.addMessage("Module "+_name+" selected as Trigger."); //no sense it printing this since it can't be changed
                        } else {
			    if (_channels._trigger!=null)
                            if (_channels._trigger.isSelected())
                                _channels.setTrigger(false);
                        }
                    } 
                    /* check to see if we are the new incrementer module */
                    else if (e.getActionCommand().contains("incrementer")){
                        if (e.getActionCommand().contains(_moduleName) && e.getActionCommand().contains(String.valueOf(_address))) //guaranteed that _incrementer exists
			{
			    if(_channels._incrementer.isSelected()) //going from unselected to selected state, need to dirty
				EventDispatcher.getInstance().fireEvent(new ActionEvent(e.getSource(), ActionEvent.ACTION_PERFORMED, CHANNEL_BUTTON_CLICK));
                            _channels.setIncrementer(true);
                            //MainFrame.addMessage("Module "+_name+" selected as Incrementer."); //no sense it printing this since it can't be changed
                        } else {
			    if (_channels._incrementer!=null)
                            if (_channels._incrementer.isSelected())
                                _channels.setIncrementer(false);
                        }
                    } 
                    /* check to see if one of our channels were selected */
                    else if (e.getActionCommand().contains(_moduleName) && e.getActionCommand().contains(String.valueOf(_address))) {

                        String channelStr = e.getActionCommand().substring((e.getActionCommand().indexOf('^') + 1), e.getActionCommand().length());
         
                        int channel = Integer.parseInt(channelStr);
                        JRadioButton source = (JRadioButton) e.getSource();

			
			if( (channel==15) && ((_moduleType==ModulePane.MODULE_TYPE_TRIG) || (_moduleType==ModulePane.MODULE_TYPE_INC)) )
			{
			    if(source.isSelected()) //going from unselected to selected state, need to dirty
				EventDispatcher.getInstance().fireEvent(new ActionEvent(e.getSource(), ActionEvent.ACTION_PERFORMED, CHANNEL_BUTTON_CLICK));

			    source.setSelected(true);
			    return; //we are just ignoring this, so we don't need to do the rest
			}

                        /* Bubble the event up the EventDispatcher*/
                        //if (!_channels._dirty) //this _dirty is never set or cleared, so why check it
			{
                            EventDispatcher.getInstance().fireEvent(new ActionEvent(e.getSource(), ActionEvent.ACTION_PERFORMED, CHANNEL_BUTTON_CLICK));
			    //channels._dirty = true;
                        }

                        if (source.isSelected()) {
                            _channels._channelsArray[channel] = true;
                        } else {
                            _channels._channelsArray[channel] = false;
                        }
                    }
                } catch (NumberFormatException nfe) {
                    System.out.println(nfe.getMessage());
                }
            }
        }
    }
    
    
    public static final long serialVersionUID = 1L;
    public static final String CHANNEL_BUTTON_CLICK = "CHANNEL_BUTTON_CLICK";

    private String _address;
    private String _addrSpace;
    private String _dataWidth;
    private String _dataSize;
    private int _moduleType;
    private String _name;
    public final static int MODULE_TYPE_DATA = 1;
    public final static int MODULE_TYPE_INC = 2;
    public final static int MODULE_TYPE_TRIG = 3;
    private ChannelsPane _channels;
    public static final Dimension MAX_SIZE = new Dimension(125, 345);
}
