// package nsrlDataAcquisition;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.JDOMException;
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */ /**
 *
 * @author pucci
 */


public class XmlUtils {

    private XmlUtils() {
        _factory = new DefaultJDOMFactory();
        _builder = new SAXBuilder();
        _outputter = new XMLOutputter();
        String dir = System.getProperty("user.dir");
        DEFAULT_RUN_CONFIG = dir + "/run.xml";
        DEFAULT_MODULE_CONFIG = dir + "/nsrlDataAcquisition.conf";
    }

    public synchronized static XmlUtils getInstance() {
        if (_instance == null) {
            _instance = new XmlUtils();
        }

        return _instance;
    }

    /**
     * This utility function returns a org.jdom.Document containing the xml file
     * specified.
     * 
     * @param _fileName
     * @return
     * @throws org.jdom.JDOMException
     * @throws java.io.IOException
     */
    public Document loadXml(String _fileName) throws JDOMException, IOException {
        Document doc = _builder.build(new File(_fileName));

        if (doc != null) {
            return doc;
        } else {
            return null;
        }
    }

    /**
     * The load module config loads the configuration information for the 
     * module panels which are seen in the top half of the GUI.
     * 
     * @return Vector<ModulePane> -- the ModulePane's for each module.
     */
    public Vector<ModulePane> loadModuleConfig(String config)
            throws JDOMException, IOException {
		Vector<ModulePane> panes = new Vector<ModulePane>();

		if (config == null)
			config = DEFAULT_MODULE_CONFIG;
		Document doc = _builder.build(new File(config));
        
	
        //for debug only
        System.out.println("Load config file from :  "+ config); 
        
        try {
            Element root = doc.getRootElement();
            List modules = root.getChildren("module");
            if (modules != null && modules.size() > 0) {
                ListIterator itr = modules.listIterator();
                while (itr.hasNext()) {
                    Element module = (Element) itr.next();

                    String name = module.getAttributeValue("name");


                    String moduleType = module.getAttributeValue("type");

                    int type = 0;
                    if (moduleType.equals("data")) {
                        type = ModulePane.MODULE_TYPE_DATA;
                    } else if (moduleType.equals("incrementer")) {
                        type = ModulePane.MODULE_TYPE_INC;
                    } else if (moduleType.equals("trigger")) {
                        type = ModulePane.MODULE_TYPE_TRIG;
                    }

                    String address = module.getChildText("address");
                    String addrspace = module.getChildText("addrspace");
                    String datawidth = module.getChildText("datawidth");
                    String datasize = module.getChildText("datasize");
		    //System.out.println("Module Setup: " + name + " " + datasize);

                    List channels = (module.getChild("channels")).getChildren("channel");
                    ListIterator chanItr = channels.listIterator();

                    //Now read in the names of each channel
                    String[] channelNames = new String[channels.size()];
                    int i = 0;
                    while (chanItr.hasNext()) {
                        Element channel = (Element) chanItr.next();
                        channelNames[i] = channel.getAttributeValue("name");
                        //for debug only
                        //System.out.println("Load channel "+i+" : " + channelNames[i]);                   
                        i++;
                    }

                    panes.add(new ModulePane(name, address, addrspace,
                            datawidth, datasize, channelNames, channelNames.length, type));
                }

            }
        } catch (Exception ex) {
	    System.out.println(ex);
	    ex.printStackTrace();
            throw new JDOMException("Illegal XML format.");
        }



        return panes;
    }

    public HashMap<String, String> loadXMLIntoHeader(String _fileName)
            throws JDOMException, IOException {
        HashMap<String, String> paneData = new HashMap<String, String>();
        Document doc = _builder.build(new File(_fileName));

        try {
            Element root = doc.getRootElement();
            Element header = root.getChild("header");

            if (header != null) {
                paneData.put(ConfigurationPane.CONFIG_NAME_FIELD,
                        header.getChild("configname").getText());
                paneData.put(ConfigurationPane.DATE_TIME_FIELD,
                        header.getChild("datetime").getText());
                paneData.put(ConfigurationPane.USERS_FIELD,
                        header.getChild("users").getText());
                paneData.put(ConfigurationPane.OUTPUT_FILE_FIELD,
                        header.getChild("output").getText());
                paneData.put(ConfigurationPane.ION_SPECIES_FIELD,
                        header.getChild("ionspecies").getText());
                paneData.put(ConfigurationPane.ENERGY_FIELD,
                        header.getChild("energy").getText());
                paneData.put(ConfigurationPane.NUM_EVENTS_FIELD,
                        header.getChild("events").getText());
		if(header.getChild("timeout")!=null)
		{
		    paneData.put(ConfigurationPane.TIME_OUT_FIELD,
				 header.getChild("timeout").getText());
		}
                paneData.put(ConfigurationPane.COMMENTS_FIELD,
                        header.getChild("comments").getText());
                paneData.put(ConfigurationPane.CONFIG_FILE_NAME, _fileName);
            }
        } catch (Exception ex) {
	    ex.printStackTrace();
            throw new JDOMException("Illegal XML format.");
        }


        return paneData;
    }

    public void loadXMLIntoModules(String _fileName,
            Vector<ModulePane> panels)
            throws JDOMException, IOException {
        HashMap<String, String> paneData = new HashMap<String, String>();

        Document doc = _builder.build(new File(_fileName));

        //for debug only
        System.out.println("Load file:  "+_fileName);   
        
        try {
            Element root = doc.getRootElement();
            List modules = root.getChildren("module");
            Enumeration<ModulePane> panes = panels.elements();

            if (modules != null && modules.size() > 0) {
                ListIterator itr = modules.listIterator();
                while (itr.hasNext()) {
                    Element module = (Element) itr.next();

                    ModulePane panel = panes.nextElement();
		    
					if (panel != null
							&& panel.getName().equals(
									module.getAttributeValue("name")))
					{
						/*
						 * String moduleType = module.getAttributeValue("type");
						 * 
						 * if (moduleType.equals("data")) { panel.setModuleType(ModulePane.MODULE_TYPE_DATA); } else if
						 * (moduleType.equals("incrementer")) { panel.setModuleType(ModulePane.MODULE_TYPE_INC); } else
						 * if (moduleType.equals("trigger")) { panel.setModuleType(ModulePane.MODULE_TYPE_TRIG); }
						 * 
						 * panel.setAddress(module.getChildText("address"));
						 * panel.setAddrSpace(module.getChildText("addrspace"));
						 * panel.setDataWidth(module.getChildText("datawidth"));
						 * panel.setDataSize(module.getChildText("datasize"));
						 */

						List channels = (module.getChild("channels"))
								.getChildren("channel");
						ListIterator chanItr = channels.listIterator();
						while (chanItr.hasNext())
						{
							Element channel = (Element) chanItr.next();
							panel.setChannelActive(Integer.parseInt(channel.getText()));
						    panel.setChannelName(Integer.parseInt(channel.getText()), channel.getAttributeValue("name"));
						}
					}
				}
			}
		}
		catch (Exception ex)
		{
			throw new JDOMException("Illegal XML format.");
		}
	}

    public boolean saveXml(File file, Vector<ModulePane> panels,
            HashMap<String, String> headerData)
            throws java.lang.NullPointerException {

        if (file == null || file.equals("")) {
            throw new java.lang.NullPointerException("Empty File Name");
        }
        try {
        	
        	
            //for debug only
            System.out.println("Saved into file:  "+file.getPath());
        	
            /*Build our root document and element*/
            Document doc = _factory.document(new Element("daqconfig"));
            String dir = System.getProperty("user.dir") + "/";
            doc.setDocType(new DocType("daqconfig",
                    dir + "daqconfig.dtd"));
            Element root = doc.getRootElement();

            /*Build the header portion of the xml*/
            Element header = new Element("header");

            Element configname = new Element("configname");
            configname.setText(headerData.get(ConfigurationPane.CONFIG_NAME_FIELD));
            header.addContent(configname);

            Element datetime = new Element("datetime");
            datetime.setText(headerData.get(ConfigurationPane.DATE_TIME_FIELD));
            header.addContent(datetime);

            Element users = new Element("users");
            users.setText(headerData.get(ConfigurationPane.USERS_FIELD));
            header.addContent(users);

            Element output = new Element("output");
            output.setText(headerData.get(ConfigurationPane.OUTPUT_FILE_FIELD));
            header.addContent(output);

            Element ionspecies = new Element("ionspecies");
            ionspecies.setText(headerData.get(ConfigurationPane.ION_SPECIES_FIELD));
            header.addContent(ionspecies);

            Element energy = new Element("energy");
            energy.setText(headerData.get(ConfigurationPane.ENERGY_FIELD));
            header.addContent(energy);

            Element events = new Element("events");
            events.setText(headerData.get(ConfigurationPane.NUM_EVENTS_FIELD));
            header.addContent(events);

            Element timeout = new Element("timeout");
            timeout.setText(headerData.get(ConfigurationPane.TIME_OUT_FIELD));
            header.addContent(timeout);

            Element comments = new Element("comments");
            comments.setText(headerData.get(ConfigurationPane.COMMENTS_FIELD));
            header.addContent(comments);

            root.addContent(header);

            /*Now build the modules section of the XML file*/

            Enumeration<ModulePane> elements = panels.elements();

            /*Loop through the panels _hash table to create the XML*/
            while (elements.hasMoreElements()) {

                //get the next panel off the hashtable
                ModulePane panel = elements.nextElement();

                //this vector will hold all our child nodes
                Vector<Element> childNodes = new Vector<Element>();

                //first create our main Element <module>
                Element module = new Element("module");
                module.setAttribute("name", panel.getName());

                switch (panel.getModuleType()) {
                    case ModulePane.MODULE_TYPE_DATA:
                        module.setAttribute("type", "data");
                        break;
                    case ModulePane.MODULE_TYPE_INC:
                        module.setAttribute("type", "incrementer");
                        break;
                    case ModulePane.MODULE_TYPE_TRIG:
                        module.setAttribute("type", "trigger");
                        break;
                }

                //first create the other specific sub components
                Element address = new Element("address");
                address.setText(panel.getAddress());
                childNodes.add(address);
                Element addrspace = new Element("addrspace");
                addrspace.setText(panel.getAddrSpace());
                childNodes.add(addrspace);
                Element datawidth = new Element("datawidth");
                datawidth.setText(panel.getDataWidth());
                childNodes.add(datawidth);
                Element datasize = new Element("datasize");
                datasize.setText(panel.getDataSize());
                childNodes.add(datasize);

                //next create the channels sub element
                boolean[] channelsArray = panel.getChannels();
                String[] channelNames = panel.getChannelNames();
                Element channels = new Element("channels");
                channels.setAttribute("size",
                        String.valueOf(channelsArray.length));

                for (int i = 0; i < channelsArray.length; i++) {
                    if (channelsArray[i]) {
                        Element channel = new Element("channel");
                        channel.setText(String.valueOf(i));
                        channel.setAttribute("name", channelNames[i]);
                        
                        //for debug only
                        System.out.println("Saved channel "+i+" : "+channelNames[i]);
                        channels.addContent(channel);
                    }
                }


                childNodes.add(channels);
                //now build our module node and then add it to the <daqconfig>
                module.setContent(childNodes);
                root.addContent(module);


            }

            _outputter.output(doc, new FileOutputStream(file));

            //the save operation was successful
            return true;

        } catch (Exception e) {
            throw new java.lang.UnknownError("Could not save file.");
        }
    }

    public boolean saveRunXml(Vector<ModulePane> panels,
            HashMap<String, String> headerData) {

        try {
            int autonum = 1;
	    String dataFile = MainFrame.DEFAULT_DATA_DIR;
	    if (Main.MODE == Constants.ZDC)
		dataFile += "zdc/";
	    else if (Main.MODE == Constants.NSRL)
		dataFile += "nsrl/";
            dataFile += headerData.get(ConfigurationPane.ION_SPECIES_FIELD).replaceAll("\\s", "_");
            ;
            dataFile += "_" + headerData.get(ConfigurationPane.ENERGY_FIELD).replaceAll("\\s", "_");
            Calendar cal = Calendar.getInstance();
            dataFile += "_" + cal.get(Calendar.DAY_OF_MONTH);
            dataFile += "_" + (cal.get(Calendar.MONTH) + 1);
            dataFile += "_" + cal.get(Calendar.YEAR);
            String autoNumString = "_" + "00" + autonum + ".ascii";

            File outputFile = new File((dataFile + autoNumString));
            while (outputFile.exists()) {
                ++autonum;

                if (String.valueOf(autonum).length() == 1) {
                    autoNumString = "_" + "00" + autonum + ".ascii";
                } else if (String.valueOf(autonum).length() == 2) {
                    autoNumString = "_" + "0" + autonum + ".ascii";
                } else if (String.valueOf(autonum).length() == 3) {
                    autoNumString = "_" + autonum + ".ascii";
                }
                outputFile = new File(dataFile + autoNumString);
            }

            dataFile += autoNumString;

            /*Build our root document and element*/
            Document doc = _factory.document(new Element("daqconfig"));
            String dir = System.getProperty("user.dir") + "/";
            doc.setDocType(new DocType("daqconfig",
                    dir + "daqconfig.dtd"));
            Element root = doc.getRootElement();

            /*Build the header portion of the xml*/
            Element header = new Element("header");

            Element configname = new Element("configname");
            configname.setText(headerData.get(ConfigurationPane.CONFIG_NAME_FIELD));
            header.addContent(configname);

            Element datetime = new Element("datetime");
            datetime.setText(headerData.get(ConfigurationPane.DATE_TIME_FIELD));
            header.addContent(datetime);

            Element users = new Element("users");
            users.setText(headerData.get(ConfigurationPane.USERS_FIELD));
            header.addContent(users);

            Element output = new Element("output");
            output.setText(dataFile);
            header.addContent(output);

            Element ionspecies = new Element("ionspecies");
            ionspecies.setText(headerData.get(ConfigurationPane.ION_SPECIES_FIELD));
            header.addContent(ionspecies);

            Element energy = new Element("energy");
            energy.setText(headerData.get(ConfigurationPane.ENERGY_FIELD));
            header.addContent(energy);

            Element events = new Element("events");
            events.setText(headerData.get(ConfigurationPane.NUM_EVENTS_FIELD));
            header.addContent(events);

            Element timeout = new Element("timeout");
            timeout.setText(headerData.get(ConfigurationPane.TIME_OUT_FIELD));
            header.addContent(timeout);

            Element comments = new Element("comments");
            comments.setText(headerData.get(ConfigurationPane.COMMENTS_FIELD));
            header.addContent(comments);

            root.addContent(header);

            /*Now build the modules section of the XML file*/

            Enumeration<ModulePane> elements = panels.elements();

            /*Loop through the panels _hash table to create the XML*/
            while (elements.hasMoreElements()) {

                //get the next panel off the hashtable
                ModulePane panel = elements.nextElement();

                //this vector will hold all our child nodes
                Vector<Element> childNodes = new Vector<Element>();

                //first create our main Element <module>
                Element module = new Element("module");
                module.setAttribute("name", panel.getName());

                switch (panel.getModuleType()) {
                    case ModulePane.MODULE_TYPE_DATA:
                        module.setAttribute("type", "data");
                        break;
                    case ModulePane.MODULE_TYPE_INC:
                        module.setAttribute("type", "incrementer");
                        break;
                    case ModulePane.MODULE_TYPE_TRIG:
                        module.setAttribute("type", "trigger");
                        break;
                }

                //first create the other specific sub components
                Element address = new Element("address");
                address.setText(panel.getAddress());
                childNodes.add(address);
                Element addrspace = new Element("addrspace");
                addrspace.setText(panel.getAddrSpace());
                childNodes.add(addrspace);
                Element datawidth = new Element("datawidth");
                datawidth.setText(panel.getDataWidth());
                childNodes.add(datawidth);
                Element datasize = new Element("datasize");
                datasize.setText(panel.getDataSize());
                childNodes.add(datasize);

                //next create the channels sub element
                boolean[] channelsArray = panel.getChannels();
                String[] channelNames = panel.getChannelNames();
                Element channels = new Element("channels");
                channels.setAttribute("size",
                        String.valueOf(channelsArray.length));

                for (int i = 0; i < channelsArray.length; i++) {
                    if (channelsArray[i]) {
                        Element channel = new Element("channel");
                        channel.setText(String.valueOf(i));
                        channel.setAttribute("name", channelNames[i]);
                        channels.addContent(channel);
                    }
                }


                childNodes.add(channels);
                //now build our module node and then add it to the <daqconfig>
                module.setContent(childNodes);
                root.addContent(module);


            }


            _outputter.output(doc, new FileOutputStream(DEFAULT_RUN_CONFIG));

            //the save operation was successful
            return true;

        } catch (Exception ex) {
            return false;
        }
    }

    /**
     * Convenience method for starting data console. This parses the current
     * running configuration files for the active channel channel names.
     * 
     * @return String[] containing the names of each active channel.
     */
	public Vector<String> getRunColumnNames() throws JDOMException, IOException
	{
		
		Vector<String> colNames = new Vector<String>();

		/* Attempt to load the currently running config file */
		Document doc = _builder.build(new File(DEFAULT_RUN_CONFIG));


		
		List modules = (doc.getRootElement()).getChildren("module");		
		if (modules != null && modules.size() > 0)
		{
			ListIterator itr = modules.listIterator();
			while (itr.hasNext())
			{
				Element module = (Element) itr.next();
				List channels = (module.getChild("channels"))
						.getChildren("channel");
				ListIterator chanItr = channels.listIterator();
				while (chanItr.hasNext())
				{
					colNames.add(((Element) chanItr.next())
							.getAttributeValue("name"));
				}
			}
		}
		return colNames;
	}
    
    /**
     * Another convenience method for starting the data console. This returns
     * the data file to watch for the currently running config.
     * 
     * @return the file path to the data file.
     */
    public String getConfigOuputFile() throws JDOMException, IOException {
        String filename = "";
        
        /* Attempt to load the currently running config file */
        Document doc = _builder.build(new File(DEFAULT_RUN_CONFIG));
        
        return (doc.getRootElement().getChild("header")).getChildText("output");
    }

    /* Deltes the default run.xml~ file */
    public void deleteRunConfig() {
	/*
        try {
            File file = new File(DEFAULT_RUN_CONFIG);

            if (file.exists()) {
                file.delete();
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
	*/
    }
    
    public static final long serialVersionUID = 1L;
    private JDOMFactory _factory;
    private SAXBuilder _builder;
    private XMLOutputter _outputter;
    private Vector<ModulePane> _hash;
    private static XmlUtils _instance = null;
    public static String DEFAULT_RUN_CONFIG = null;
    public static String DEFAULT_MODULE_CONFIG = null;
}
